package cn.com.duiba.oto.dto.oto.board;

import lombok.Data;

import java.io.Serializable;

/**
 * 表格列分组DTO
 * 用于表示表头的分组信息（如"类型"、"经营数据"、"经营指标"等）
 *
 * @author xiaotian
 * @date 2025-01-27
 */
@Data
public class BoardTableColumnGroupDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 分组名称（如"类型"、"经营数据"、"经营指标"等）
     */
    private String name;

    /**
     * 该分组包含的列数（跨列数）
     */
    private Integer colspan;

    /**
     * 该分组起始列的索引（从0开始）
     * 例如：类型分组从索引0开始，经营数据从索引1开始
     */
    private Integer startIndex;
}

