package cn.com.duiba.oto.param.oto.wx.menu;

import cn.com.duiba.oto.param.oto.wx.WxBaseParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.List;

/**
 * 创建默认菜单
 *
 * @author xiaotian
 * @date 2020/9/29 11:51 AM
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class CreateDefaultMenuParam extends WxBaseParam {

    private static final long serialVersionUID = 5327104640391943496L;

    /**
     * 一级菜单数组，个数应为1~3个
     */
    @NotNull(message = "一级菜单列表不能为空")
    @Size(min = 1, max = 3, message = "一级菜单个数不能小于1个或超过3个")
    private List<ButtonParam> button;
}
