package cn.com.duiba.oto.enums.cust.visit;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-01-10 14:03
 */
@AllArgsConstructor
@Getter
public enum OtoCustFamilyTypeEnum {

    SELF(1, "自己"),
    MATE(2, "配偶"),
    PARENT(3, "父母"),
    CHILDREN(4, "子女");

    /**
     * 状态
     */
    private final Integer status;

    /**
     * 备注
     */
    private final String desc;

    /**
     * 包含所有枚举的Map
     */
    private static final Map<Integer, String> ALL_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(OtoCustFamilyTypeEnum::getStatus, OtoCustFamilyTypeEnum::getDesc, (v1, v2)->v1)));

    /**
     * 根据状态获取描述
     */
    public static String getDescByStatus(Integer status){
        if (status == null) {
            return null;
        }
        return ALL_MAP.get(status);
    }
}
