/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.oto.enums.activity;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum ActivityRecordSourceEnum {
    OWN(0, "\u81ea\u7136\u6d41\u91cf"),
    SHARE(1, "\u5206\u4eab\u83b7\u53d6"),
    BACK(2, "\u7ba1\u7406\u540e\u53f0\u6dfb\u52a0"),
    SELLER(3, "\u9500\u552e\u624b\u52a8\u6dfb\u52a0");

    private static final Map<Integer, ActivityRecordSourceEnum> INNER_MAP;
    private final Integer code;
    private final String desc;

    private ActivityRecordSourceEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ActivityRecordSourceEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return INNER_MAP.get(code).getDesc();
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        INNER_MAP = Collections.unmodifiableMap(Arrays.stream(ActivityRecordSourceEnum.values()).collect(Collectors.toMap(ActivityRecordSourceEnum::getCode, Function.identity(), (v1, v2) -> v1)));
    }
}

