package cn.com.duiba.oto.param.oto.tag;

import cn.com.duiba.oto.enums.OtoTagStatusEnum;
import cn.com.duiba.oto.param.oto.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * OTO-标签筛选参数
 *
 * @author xiaotian
 * @date 2023/12/27 11:39 上午
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class RemoteTagQueryParam extends PageQuery {

    private static final long serialVersionUID = -3184308710234300518L;

    /**
     * 标签名称
     */
    private String tagName;

    /**
     * 角色
     */
    private List<Integer> roleTypes;

    /**
     * 可见部门
     */
    private List<Long> deptIds;

    /**
     * 标签状态,0-关闭,1-开启
     * {@link OtoTagStatusEnum}
     */
    private Integer tagStatus;
}
