package cn.com.duiba.oto.dto.oto.board;

import lombok.Data;

import java.io.Serializable;

/**
 * 表格列DTO
 * 用于存储表格列的名称和描述信息
 *
 * @author xiaotian
 * @date 2025-01-27
 */
@Data
public class BoardTableColumnDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 列名（显示在表头）
     */
    private String name;

    /**
     * 列描述（用于说明该列的含义、计算公式等）
     * 例如："10到3"列的描述为"产说会活动量/新接客户总数"
     */
    private String description;

    /**
     * 列所属的分组名称（可选）
     * 用于表头分组显示，如"类型"、"经营数据"、"经营指标"、"高客经营表现"等
     * 如果为空，则表示该列不属于任何分组
     */
    private String groupName;
}

