package cn.com.duiba.paycenter.dto.charge;

import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;

/**
 * 支付收单回执
 *
 * @author zhangruofan
 * @date 2018/11/14
 */
public abstract class BaseChargeResponse implements Serializable {
    private static final long serialVersionUID = 5310381202979072350L;
    /**
     * 第三方支付下单是否成功
     */
    private boolean success;
    /**
     * 第三方支付错误信息描述
     */
    private String message;
    /**
     * 支付流水号
     */
    private String orderNo;

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }


    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * 将账户信息等存入extra中
     * @return jsonString
     */
    public abstract String getExtra();

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
