package cn.com.duiba.paycenter.enums;

import org.apache.commons.lang.StringUtils;

import java.util.Arrays;

/**
 * 支付渠道枚举
 * @author zhangruofan
 * @date 2018/11/05
 */
public enum ChannelEnum {

    DUIBA_LIVE_MP_PAY("dbl_mp_pay", "兑吧直播小程序支付"),

    DUIBA_LIVE_INSTALLMENT_PAY("dbl_installment_pay", "兑吧直播分期支付"),

    ;

    private String channelType;
    private String channelName;

    ChannelEnum(String channelType, String channelName) {
        this.channelType = channelType;
        this.channelName = channelName;
    }

    public String getChannelType() {
        return channelType;
    }

    public String getChannelName() {
        return channelName;
    }

    public static String getChannelName(String channelType) {
        if (StringUtils.isBlank(channelType)) {
            return null;
        }
        if (isActive(channelType)) {
            return ChannelEnum.valueOf(channelType).channelName;
        }
        return null;
    }

    /**
     * 返回channelId是否有效
     * @param channelType 渠道
     * @return 是否有效
     */
    public static boolean isActive(String channelType) {
        if (StringUtils.isBlank(channelType)) {
            return false;
        }
        return Arrays.stream(ChannelEnum.values())
                .anyMatch(channelEnum -> channelEnum.channelType.equals(channelType));
    }
}
