package cn.com.duiba.paycenter.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.paycenter.dto.charge.ChargeOrderDto;
import cn.com.duiba.paycenter.dto.charge.installment.DuibaLiveInstallmentChargeRequest;
import cn.com.duiba.paycenter.dto.charge.installment.DuibaLiveInstallmentChargeResponse;
import cn.com.duiba.paycenter.dto.charge.mp.DuibaLiveMpChargeRequest;
import cn.com.duiba.paycenter.dto.charge.mp.DuibaLiveMpChargeResponse;

import java.util.List;

/**
 * @author zhangruofan
 * @date 2018/11/14
 */
@AdvancedFeignClient
public interface RemoteChargeService {

    /**
     * 查询支付订单详情
     *
     * @param orderNo 支付订单号
     * @return chargeOrderDto
     * @throws BizException bizException
     */
    ChargeOrderDto findByOrderNo(String orderNo) throws BizException;

    /**
     * 根据业务订单号查询支付信息
     *
     * @param bizOrderNo 业务主订单号
     * @return chargeOrderDto
     * @throws BizException bizException
     */
    List<ChargeOrderDto> findByBizOrderNo(String bizOrderNo) throws BizException;

    /**
     * 查询支付订单详情
     *
     * @param orderNos 支付订单号
     * @return List<ChargeOrderDto>
     * @throws BizException bizException
     */
    List<ChargeOrderDto> batchFindByOrderNo(List<String> orderNos) throws BizException;


    /**
     * 获取支付订单详情
     * @param bizNo 业务方流水号
     * @param bizType 业务方类型
     * @return ChargeOrderDto
     */
    ChargeOrderDto findByBizNoAndBizType(String bizNo, Integer bizType);

    /**
     * 同一个biztype 多个bizOrderNo批量查询
     * @param bizNos
     * @param bizType
     * @return
     */
    public List<ChargeOrderDto> selectByBizNosAndBizType(List<String> bizNos, Integer bizType);

    /**
     * 同一个biztype 多个bizOrderNo批量查询
     * @param bizNos
     * @param bizType
     * @return
     */
     List<ChargeOrderDto> listByBizNosAndBizType(List<String> bizNos, Integer bizType);


    /**
     * 兑吧直播小程序支付
     *
     * @param chargeRequest
     * @return
     * @throws BizException
     */
    DuibaLiveMpChargeResponse createDuibaLiveMpCharge(DuibaLiveMpChargeRequest chargeRequest) throws BizException;

    /**
     * 兑吧直播分期支付
     *
     * @param chargeRequest
     * @return
     * @throws BizException
     */
    DuibaLiveInstallmentChargeResponse createDuibaLiveInstallmentCharge(DuibaLiveInstallmentChargeRequest chargeRequest) throws BizException;
}
