/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.paycenter.enums.duibaaccount;

import java.util.Arrays;
import java.util.Objects;

public enum AppAccountRelationTypeEnum {
    SALE(12, "\u5356\u51fa"),
    SETTLE(8, "\u7ed3\u7b97"),
    ONLINE_CHARGE(1, "\u5145\u503c"),
    ONLINE_CHARGE_FEE(2, "\u5145\u503c\u624b\u7eed\u8d39"),
    WITHDRAW(3, "\u63d0\u73b0"),
    WITHDRAW_FEE(4, "\u63d0\u73b0\u624b\u7eed\u8d39"),
    WITHDRAW_PAYBACK(5, "\u63d0\u73b0\u5931\u8d25\u9000\u56de"),
    MANUAL_CHARGE(6, "\u4eba\u5de5\u5145\u503c"),
    MANUAL_REDUCE(7, "\u4eba\u5de5\u51cf\u6b3e"),
    REFUND(9, "\u9000\u6b3e"),
    PURCHASE(10, "\u91c7\u8d2d"),
    PURCHASE_PAYBACK(11, "\u91c7\u8d2d\u9000\u56de"),
    USER_REWARD(13, "\u7ea2\u5305"),
    USER_REWARD_PAYBACK(14, "\u7ea2\u5305\u9000\u56de"),
    BUY_SAAS_SERVE(15, "\u8d2d\u4e70\u670d\u52a1"),
    FUND_COLLECTION(16, "\u8d44\u91d1\u5f52\u96c6");

    private Integer code;
    private String desc;

    private AppAccountRelationTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static String getDescByCode(Integer code) {
        if (Objects.isNull(code)) {
            return "";
        }
        AppAccountRelationTypeEnum typeEnum = AppAccountRelationTypeEnum.getByCode(code);
        if (Objects.nonNull((Object)typeEnum)) {
            return typeEnum.getDesc();
        }
        return "";
    }

    public static AppAccountRelationTypeEnum getByCode(Integer code) {
        return Arrays.stream(AppAccountRelationTypeEnum.values()).filter(a -> a.code.equals(code)).findFirst().orElse(null);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }
}

