package cn.com.duiba.paycenter.dto.payment.charge.unionpay;

import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeRequest;
import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeResponse;
import com.alibaba.fastjson.JSON;

public class UnionPayWapChargeResponse extends BaseChargeResponse {
    private static final long serialVersionUID = 5812770494274552377L;

    /**
     * 银联受理订单号
     * 获取 tn 后半小时内要调控件，调控件后 1 小时内要发起支付
     */
    private String tn;
    private String merId;
    private String txnTime;


    public UnionPayWapChargeResponse(BaseChargeRequest request) {
        this.setOrderNo(request.getBizOrderNo());
    }

    public UnionPayWapChargeResponse() {
    }

    /**
     * 将账户信息等存入extra中
     * response.extra->entity.extra->request.metadata=幂等
     * {@link }
     *
     * @return jsonString
     */
    @Override
    public String getExtra() {
        UnionPayChargeOrderExtra extra = new UnionPayChargeOrderExtra();
        extra.setMerId(merId);
        extra.setTxnTime(txnTime);
        extra.setTn(tn);
        return JSON.toJSONString(extra);
    }

    public String getTn() {
        return tn;
    }

    public void setTn(String tn) {
        this.tn = tn;
    }

    public String getMerId() {
        return merId;
    }

    public void setMerId(String merId) {
        this.merId = merId;
    }

    public String getTxnTime() {
        return txnTime;
    }

    public void setTxnTime(String txnTime) {
        this.txnTime = txnTime;
    }
}
