/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.paycenter.client;

import cn.com.duiba.paycenter.client.RpcResult;
import cn.com.duiba.paycenter.result.AmbResult;
import cn.com.duiba.paycenter.service.AmbPayCenterService;
import cn.com.duiba.paycenter.util.SignUtil;
import java.util.HashMap;

public class AmbPayCenterServiceClient {
    private AmbPayCenterService ambPayCenterService;

    public RpcResult<AmbResult> consumerPay(Long developerId, Long orderId, Long consumerPrice, AmbPayCenterService.AmbPayParams p) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("developerId", developerId + "");
            params.put("orderId", orderId + "");
            params.put("consumerPrice", consumerPrice + "");
            String sign = SignUtil.sign(params);
            AmbResult ret = this.ambPayCenterService.consumerPay(developerId, orderId, consumerPrice, p, sign);
            return new RpcResult<AmbResult>(ret);
        }
        catch (Exception e) {
            return new RpcResult<AmbResult>(e);
        }
    }

    @Deprecated
    public RpcResult<AmbResult> consumerPayBack(Long developerId, Long orderId, Long paybackMoney, AmbPayCenterService.AmbPayParams p) {
        return this.consumerPayBackNew(developerId, orderId, paybackMoney, null, p);
    }

    public RpcResult<AmbResult> consumerPayBackNew(Long developerId, Long orderId, Long paybackMoney, Long ordersItemId, AmbPayCenterService.AmbPayParams p) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("developerId", developerId + "");
            params.put("orderId", orderId + "");
            params.put("paybackMoney", paybackMoney + "");
            params.put("ordersItemId", ordersItemId + "");
            String sign = SignUtil.sign(params);
            AmbResult ret = this.ambPayCenterService.consumerPayBack(developerId, orderId, paybackMoney, ordersItemId, p, sign);
            return new RpcResult<AmbResult>(ret);
        }
        catch (Exception e) {
            return new RpcResult<AmbResult>(e);
        }
    }

    public RpcResult<AmbResult> dlpWithdrawToRemaining(Long developerId, Long withdrawCashOrderId, Long money, AmbPayCenterService.AmbPayChargeExtraParams p) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("developerId", developerId + "");
            params.put("withdrawCashOrderId", withdrawCashOrderId + "");
            params.put("money", money + "");
            String sign = SignUtil.sign(params);
            AmbResult ret = this.ambPayCenterService.dlpWithdrawToRemaining(developerId, withdrawCashOrderId, money, p, sign);
            return new RpcResult<AmbResult>(ret);
        }
        catch (Exception e) {
            return new RpcResult<AmbResult>(e);
        }
    }

    public RpcResult<AmbResult> orderSettle(Long orderId, Long duibaMoney, Long devMoney, AmbPayCenterService.AmbPayChargeExtraParams p) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("orderId", orderId + "");
            params.put("duibaMoney", duibaMoney + "");
            params.put("devMoney", devMoney + "");
            String sign = SignUtil.sign(params);
            AmbResult ret = this.ambPayCenterService.orderSettle(orderId, duibaMoney, devMoney, p, sign);
            return new RpcResult<AmbResult>(ret);
        }
        catch (Exception e) {
            return new RpcResult<AmbResult>(e);
        }
    }

    public RpcResult<AmbResult> orderSettleWithFee(Long orderId, Long duibaMoney, Long devMoney, Long fee, AmbPayCenterService.AmbPayChargeExtraParams p) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("orderId", orderId + "");
            params.put("duibaMoney", duibaMoney + "");
            params.put("devMoney", devMoney + "");
            params.put("fee", fee + "");
            String sign = SignUtil.sign(params);
            AmbResult ret = this.ambPayCenterService.orderSettleWithFee(orderId, duibaMoney, devMoney, fee, p, sign);
            return new RpcResult<AmbResult>(ret);
        }
        catch (Exception e) {
            return new RpcResult<AmbResult>(e);
        }
    }

    public RpcResult<AmbResult> dlpWithdrawCashApply(Long developerId, Long ambDeveloperWithdrawCashOrderId, Long drawCachMoney, AmbPayCenterService.AmbPayChargeExtraParams p) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("developerId", developerId + "");
            params.put("ambDeveloperWithdrawCashOrderId", ambDeveloperWithdrawCashOrderId + "");
            params.put("drawCachMoney", drawCachMoney + "");
            String sign = SignUtil.sign(params);
            AmbResult ret = this.ambPayCenterService.dlpWithdrawCashApply(developerId, ambDeveloperWithdrawCashOrderId, drawCachMoney, p, sign);
            return new RpcResult<AmbResult>(ret);
        }
        catch (Exception e) {
            return new RpcResult<AmbResult>(e);
        }
    }

    public RpcResult<AmbResult> dlpWithdrawCashRefuse(Long developerId, Long ambDeveloperWithdrawCashOrderId, Long drawCachMoney, AmbPayCenterService.AmbPayChargeExtraParams p) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("developerId", developerId + "");
            params.put("ambDeveloperWithdrawCashOrderId", ambDeveloperWithdrawCashOrderId + "");
            params.put("drawCachMoney", drawCachMoney + "");
            String sign = SignUtil.sign(params);
            AmbResult ret = this.ambPayCenterService.dlpWithdrawCashRefuse(developerId, ambDeveloperWithdrawCashOrderId, drawCachMoney, p, sign);
            return new RpcResult<AmbResult>(ret);
        }
        catch (Exception e) {
            return new RpcResult<AmbResult>(e);
        }
    }

    public RpcResult<AmbResult> dlpWithdrawCashRefuseBySubject(Long developerId, Long ambDeveloperWithdrawCashOrderId, Long drawCachMoney, AmbPayCenterService.AmbPayChargeExtraParams p, String subjectType) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("developerId", developerId + "");
            params.put("ambDeveloperWithdrawCashOrderId", ambDeveloperWithdrawCashOrderId + "");
            params.put("drawCachMoney", drawCachMoney + "");
            String sign = SignUtil.sign(params);
            AmbResult ret = this.ambPayCenterService.dlpWithdrawCashRefuseBySubject(developerId, ambDeveloperWithdrawCashOrderId, drawCachMoney, p, sign, subjectType);
            return new RpcResult<AmbResult>(ret);
        }
        catch (Exception e) {
            return new RpcResult<AmbResult>(e);
        }
    }

    public void setAmbPayCenterService(AmbPayCenterService ambPayCenterService) {
        this.ambPayCenterService = ambPayCenterService;
    }
}

