/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.paycenter.client;

import cn.com.duiba.paycenter.client.RpcResult;
import cn.com.duiba.paycenter.constant.ActionTypes;
import cn.com.duiba.paycenter.model.AccountChangeRecordDO;
import cn.com.duiba.paycenter.params.PayOrdersExtraParams;
import cn.com.duiba.paycenter.result.PayOrdersResult;
import cn.com.duiba.paycenter.service.PayOrdersService;
import cn.com.duiba.paycenter.util.SignUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayOrdersServiceClient {
    private static final Logger log = LoggerFactory.getLogger(PayOrdersServiceClient.class);
    private PayOrdersService payOrdersService;

    public RpcResult<PayOrdersResult> payOrder(Long developerId, Long orderId, Long money, PayOrdersExtraParams p) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("developerId", developerId + "");
            params.put("orderId", orderId + "");
            params.put("money", money + "");
            String sign = SignUtil.sign(params);
            PayOrdersResult ret = this.payOrdersService.payOrder(developerId, orderId, money, sign, p);
            return new RpcResult<PayOrdersResult>(ret);
        }
        catch (Exception e) {
            return new RpcResult<PayOrdersResult>(e);
        }
    }

    public RpcResult<PayOrdersResult> backpayOrder(Long developerId, Long orderId, Long money, PayOrdersExtraParams p) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("developerId", developerId + "");
            params.put("orderId", orderId + "");
            params.put("money", money + "");
            String sign = SignUtil.sign(params);
            PayOrdersResult ret = this.payOrdersService.backpayOrder(developerId, orderId, money, sign, p);
            return new RpcResult<PayOrdersResult>(ret);
        }
        catch (Exception e) {
            return new RpcResult<PayOrdersResult>(e);
        }
    }

    public RpcResult<Boolean> checkActionSuccess(Long orderId, ActionTypes.OrdersActionType actionType) {
        try {
            boolean ret = this.payOrdersService.checkActionSuccess(orderId, actionType.getKey());
            return new RpcResult<Boolean>(ret);
        }
        catch (Exception e) {
            return new RpcResult<Boolean>(e);
        }
    }

    public void setPayOrdersService(PayOrdersService payOrdersService) {
        this.payOrdersService = payOrdersService;
    }

    public boolean updateSettleStatus(List<AccountChangeRecordDO> list) {
        try {
            return this.payOrdersService.batchUpdateRecordStatus(list);
        }
        catch (Exception e) {
            log.warn("\u6279\u91cf\u66f4\u65b0\u5f00\u53d1\u8005 \u8d26\u6237\u53d8\u66f4\u8bb0\u5f55 \u5b57\u6bb5 settleStatus \u5931\u8d25\uff0c", (Throwable)e);
            return false;
        }
    }

    public List<AccountChangeRecordDO> findByStatusLimit(Integer settleStatus, Integer limit) {
        try {
            return this.payOrdersService.findByStatusLimit(settleStatus, limit);
        }
        catch (Exception e) {
            log.warn("\u6839\u636e \u5f00\u53d1\u8005\u8d26\u6237\u53d8\u66f4\u8bb0\u5f55\u72b6\u6001\uff0c\u6279\u91cf\u67e5\u8be2 \u5f02\u5e38\uff0c", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public RpcResult<PayOrdersResult> backpayOrderByOrderItemIds(Long developerId, Long orderId, String orderItemIds, Long money, PayOrdersExtraParams p) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("developerId", developerId + "");
            params.put("orderId", orderId + "");
            params.put("money", money + "");
            params.put("orderItemIds", orderItemIds);
            String sign = SignUtil.sign(params);
            PayOrdersResult ret = this.payOrdersService.backpayOrderByOrderItemIds(developerId, orderId, money, orderItemIds, sign, p);
            return new RpcResult<PayOrdersResult>(ret);
        }
        catch (Exception e) {
            return new RpcResult<PayOrdersResult>(e);
        }
    }
}

