/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.paycenter.client;

import cn.com.duiba.paycenter.client.RpcResult;
import cn.com.duiba.paycenter.params.AppAccountPayChargeParams;
import cn.com.duiba.paycenter.remoteservice.RemoteAppAccountPayChargeService;
import cn.com.duiba.paycenter.result.PayCenterResult;
import cn.com.duiba.paycenter.util.SignUtil;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.Resource;

public class AppPayChargeServiceClient {
    private static final String DEVELOPER_ID = "developerId";
    private static final String RELATION_ID = "relationId";
    private static final String MONEY = "money";
    private static final String APP_ID = "appId";
    @Resource
    private RemoteAppAccountPayChargeService remoteAppAccountPayChargeService;

    public RpcResult<PayCenterResult> chargeMoneyByManual(AppAccountPayChargeParams payChargeParams) {
        try {
            PayCenterResult ret = this.remoteAppAccountPayChargeService.chargeMoneyByManual(payChargeParams, this.getSign(payChargeParams));
            return new RpcResult<PayCenterResult>(ret);
        }
        catch (Exception e) {
            return new RpcResult<PayCenterResult>(e);
        }
    }

    public RpcResult<PayCenterResult> chargeMoneyByOnline(AppAccountPayChargeParams params) {
        try {
            PayCenterResult ret = this.remoteAppAccountPayChargeService.chargeMoneyByOnline(params, this.getSign(params));
            return new RpcResult<PayCenterResult>(ret);
        }
        catch (Exception e) {
            return new RpcResult<PayCenterResult>(e);
        }
    }

    public RpcResult<PayCenterResult> reduceMoneyByManual(AppAccountPayChargeParams payChargeParams) {
        try {
            PayCenterResult ret = this.remoteAppAccountPayChargeService.reduceMoneyByManual(payChargeParams, this.getSign(payChargeParams));
            return new RpcResult<PayCenterResult>(ret);
        }
        catch (Exception e) {
            return new RpcResult<PayCenterResult>(e);
        }
    }

    public RpcResult<PayCenterResult> chargeMoneyFeeByOnline(AppAccountPayChargeParams payChargeParams) {
        try {
            PayCenterResult ret = this.remoteAppAccountPayChargeService.chargeMoneyFeeByOnline(payChargeParams, this.getSign(payChargeParams));
            return new RpcResult<PayCenterResult>(ret);
        }
        catch (Exception e) {
            return new RpcResult<PayCenterResult>(e);
        }
    }

    private String getSign(AppAccountPayChargeParams payChargeParams) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(DEVELOPER_ID, Objects.toString(payChargeParams.getDeveloperId()));
        params.put(RELATION_ID, payChargeParams.getRelationId());
        params.put(MONEY, Objects.toString(payChargeParams.getChangeMoney()));
        params.put(APP_ID, Objects.toString(payChargeParams.getAppId()));
        return SignUtil.sign(params);
    }
}

