package cn.com.duiba.paycenter.dto.payment.charge.cus;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @ClassName YbsRefundOrderReq
 * @Description 62vip 退款请求
 * @Author wenYongLei
 * @Date 2022/8/28 21:20
 */
public class YbsRefundOrderReq implements Serializable {
    @NotBlank(message = "退款订单号不能为空")
    private String refundNo;

    @NotNull(message = "金额不能为空")
    @Min(value = 1, message = "金额必须大于1分")
    private Integer amount;

    @NotBlank(message = "交易订单号不能为空")
    private String chargeOrderNo;

    public String getRefundNo() {
        return refundNo;
    }

    public void setRefundNo(String refundNo) {
        this.refundNo = refundNo;
    }

    public Integer getAmount() {
        return amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public String getChargeOrderNo() {
        return chargeOrderNo;
    }

    public void setChargeOrderNo(String chargeOrderNo) {
        this.chargeOrderNo = chargeOrderNo;
    }
}
