package cn.com.duiba.paycenter.dto.payment.charge.duibaLive.bf;

import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeRequest;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * @Author xujing
 * @Date 2021/5/18 1:57 下午
 */
public class DuibaLiveBFChargeRequest extends BaseChargeRequest {


    private static final long serialVersionUID = -8740336985532645429L;
    /**
     * 客户端ip
     */
    @Size(max = 16, message = "ip的长度超过16")
    private String ip;

    /**
     * openId
     */
    @NotNull(message = "用户openId不能为空")
    private String openId;

    /**
     * consumerId
     */
    @NotNull(message = "用户Id不能为空")
    private Long consumerId;

    /**
     * 商品描述
     */
    @Size(max = 255, message = "商品描述超过255")
    @NotNull(message = "商品详情不能为空")
    private String goodsDetail;

    /**
     * 供应商客户账户号
     */
    @NotBlank(message = "客户账户号不能为空")
    private String contractNo;

    /**
     * 商品供货价 单位分
     */
    @NotNull(message = "商品供货价不能为空")
    private Integer supplyPrice;

    /**
     * 供应商id
     */
    @NotNull(message = "供应商id不能为空")
    private Long supplierId;

    /**
     * 兑吧商品id
     */
    @NotNull(message = "兑吧商品id不能为空")
    private Long itemId;

    /**
     * 供应商商品id
     */
    @NotNull(message = "供应商商品id不能为空")
    private Long supplierItemId;

    /**
     * 是否跨境商品 1跨境 0非跨境
     */
    @NotNull(message = "是否跨境商品不能为空")
    private Integer crossBorder;

    /**
     * 微信小程序appId
     */
    @NotBlank(message = "微信小程序appId不能为空")
    private String wechatAppId;

    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public String getGoodsDetail() {
        return goodsDetail;
    }

    public void setGoodsDetail(String goodsDetail) {
        this.goodsDetail = goodsDetail;
    }


    public String getWechatAppId() {
        return wechatAppId;
    }

    public void setWechatAppId(String wechatAppId) {
        this.wechatAppId = wechatAppId;
    }

    public String getContractNo() {
        return contractNo;
    }

    public void setContractNo(String contractNo) {
        this.contractNo = contractNo;
    }

    public Integer getSupplyPrice() {
        return supplyPrice;
    }

    public void setSupplyPrice(Integer supplyPrice) {
        this.supplyPrice = supplyPrice;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getSupplierItemId() {
        return supplierItemId;
    }

    public void setSupplierItemId(Long supplierItemId) {
        this.supplierItemId = supplierItemId;
    }

    public Integer getCrossBorder() {
        return crossBorder;
    }

    public void setCrossBorder(Integer crossBorder) {
        this.crossBorder = crossBorder;
    }
}
