package cn.com.duiba.paycenter.dto.payment.charge.icbc.credits;

import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeRequest;

import javax.validation.constraints.NotBlank;
import java.util.Date;

/**
 * 工商银行积分换购请求对象
 *
 * @author fja
 */
public class IcbcCreditsChargeRequest extends BaseChargeRequest {

    private String bizOrderBrief;

    private String clientIp;

    @NotBlank(message = "银行卡号不能为空")
    private String accountNo;

    private String custName;

    @NotBlank(message = "手机号码不能为空")
    private String mobileno;

    /**
     * 支付通知地址
     */
    private String notifyUrl;

    /**
     * 预支付时间
     */
    private Date chargeDate;

    /**
     * 商品id
     */
    private Long appItemId;


    public String getBizOrderBrief() {
        return bizOrderBrief;
    }

    public void setBizOrderBrief(String bizOrderBrief) {
        this.bizOrderBrief = bizOrderBrief;
    }

    public String getClientIp() {
        return clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }


    public String getAccountNo() {
        return accountNo;
    }

    public void setAccountNo(String accountNo) {
        this.accountNo = accountNo;
    }

    public String getCustName() {
        return custName;
    }

    public void setCustName(String custName) {
        this.custName = custName;
    }

    public String getMobileno() {
        return mobileno;
    }

    public void setMobileno(String mobileno) {
        this.mobileno = mobileno;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public Date getChargeDate() {
        return chargeDate;
    }

    public void setChargeDate(Date chargeDate) {
        this.chargeDate = chargeDate;
    }

    public Long getAppItemId() {
        return appItemId;
    }

    public void setAppItemId(Long appItemId) {
        this.appItemId = appItemId;
    }
}
