package cn.com.duiba.paycenter.dto.equity.response;

import lombok.Data;

import java.io.Serializable;

/**
 * 权益通用响应
 * @author lizhi
 * @date 2023/4/10 4:03 PM
 */
@Data
public class EquityResponse implements Serializable {

    private static final long serialVersionUID = 2991435633620889367L;
    
    /**
     * 请求是否成功（注意仅代表请求是否成功，不代表最终结果）
     */
    private boolean success;

    /**
     * 错误信息，请求失败时有值
     */
    private String errMsg;

    /**
     * 调用第三方的唯一单号，若为null，说明调用第三方失败，且不可重试
     * 不为null的时候，仅代表未确认失败，不代表已经成功了。具体结果以回调结果或查询结果为准
     */
    private String outBizNo;
    
    public <T extends EquityResponse> T buildErr(String errMsg) {
        this.setSuccess(false);
        this.setErrMsg(errMsg);
        return (T)this;
    }
    
    public <T extends EquityResponse> T buildSuccess(String outBizNo) {
        this.setSuccess(true);
        this.setOutBizNo(outBizNo);
        return (T)this;
    }
}
