package cn.com.duiba.paycenter.dto.payment.charge.shenzhenumsunionpay;

/**
 * @author UnionPayUmsOrderQueryRequest
 * @Description
 * @date 2023/7/19 10:43
 */
public class UnionPayUmsOrderQueryBody {
    //消息ID
    String msgId;
    //报文请求时间，格式yyyy-MM-ddHH:mm:ss
    String requestTimestamp;
    //请求系统预留字段
    String srcReserve;
    //商户号
    String mid;
    //终端号
    String tid;
    //业务类型
    String instMid;
    //商户订单号
    String merOrderId;

    private UnionPayUmsOrderQueryBody(Builder builder) {
        setMsgId(builder.msgId);
        setRequestTimestamp(builder.requestTimestamp);
        setSrcReserve(builder.srcReserve);
        setMid(builder.mid);
        setTid(builder.tid);
        setInstMid(builder.instMid);
        setMerOrderId(builder.merOrderId);
    }

    public String getMsgId() {
        return msgId;
    }

    public void setMsgId(String msgId) {
        this.msgId = msgId;
    }

    public String getRequestTimestamp() {
        return requestTimestamp;
    }

    public void setRequestTimestamp(String requestTimestamp) {
        this.requestTimestamp = requestTimestamp;
    }

    public String getSrcReserve() {
        return srcReserve;
    }

    public void setSrcReserve(String srcReserve) {
        this.srcReserve = srcReserve;
    }

    public String getMid() {
        return mid;
    }

    public void setMid(String mid) {
        this.mid = mid;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getInstMid() {
        return instMid;
    }

    public void setInstMid(String instMid) {
        this.instMid = instMid;
    }

    public String getMerOrderId() {
        return merOrderId;
    }

    public void setMerOrderId(String merOrderId) {
        this.merOrderId = merOrderId;
    }


    public static final class Builder {
        private String msgId;
        private String requestTimestamp;
        private String srcReserve;
        private String mid;
        private String tid;
        private String instMid;
        private String merOrderId;

        public Builder() {
        }

        public Builder msgId(String val) {
            msgId = val;
            return this;
        }

        public Builder requestTimestamp(String val) {
            requestTimestamp = val;
            return this;
        }

        public Builder srcReserve(String val) {
            srcReserve = val;
            return this;
        }

        public Builder mid(String val) {
            mid = val;
            return this;
        }

        public Builder tid(String val) {
            tid = val;
            return this;
        }

        public Builder instMid(String val) {
            instMid = val;
            return this;
        }

        public Builder merOrderId(String val) {
            merOrderId = val;
            return this;
        }

        public UnionPayUmsOrderQueryBody build() {
            return new UnionPayUmsOrderQueryBody(this);
        }
    }
}
