package cn.com.duiba.paycenter.dto.payment.charge.shenzhenumsunionpay;

import java.util.List;

/**
 * 深圳银联对接天满saas服务平台的支付
 *
 * @author zhangdaqing
 * @date 2023/07/13
 */
public class UnionPayUmsRefundBody {
    private String msgId; // 消息ID 原样返回
    private String requestTimestamp; // 报文请求时间 格式yyyy-MM-dd HH:mm:ss
    private String srcReserve; // 请求系统预留字段
    private String merOrderId; // 商户订单号 原交易订单号
    private String instMid; // 业务类型 MINIDEFAULT
    private String mid; // 商户号
    private String tid; // 终端号
    private String targetOrderId; // 支付订单号
    private int refundAmount; // 要退货的金额
    private String refundOrderId; // 退款订单号
    private int platformAmount; // 平台商户退款分账金额
    private List<SubOrder> subOrders; // 子订单信息
    private String refundDesc; // 退货说明

    private UnionPayUmsRefundBody(Builder builder) {
        setMsgId(builder.msgId);
        setRequestTimestamp(builder.requestTimestamp);
        setSrcReserve(builder.srcReserve);
        setMerOrderId(builder.merOrderId);
        setInstMid(builder.instMid);
        setMid(builder.mid);
        setTid(builder.tid);
        setTargetOrderId(builder.targetOrderId);
        setRefundAmount(builder.refundAmount);
        setRefundOrderId(builder.refundOrderId);
        setPlatformAmount(builder.platformAmount);
        setSubOrders(builder.subOrders);
        setRefundDesc(builder.refundDesc);
    }


    public String getMsgId() {
        return msgId;
    }

    public void setMsgId(String msgId) {
        this.msgId = msgId;
    }

    public String getRequestTimestamp() {
        return requestTimestamp;
    }

    public void setRequestTimestamp(String requestTimestamp) {
        this.requestTimestamp = requestTimestamp;
    }

    public String getSrcReserve() {
        return srcReserve;
    }

    public void setSrcReserve(String srcReserve) {
        this.srcReserve = srcReserve;
    }

    public String getMerOrderId() {
        return merOrderId;
    }

    public void setMerOrderId(String merOrderId) {
        this.merOrderId = merOrderId;
    }

    public String getInstMid() {
        return instMid;
    }

    public void setInstMid(String instMid) {
        this.instMid = instMid;
    }

    public String getMid() {
        return mid;
    }

    public void setMid(String mid) {
        this.mid = mid;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTargetOrderId() {
        return targetOrderId;
    }

    public void setTargetOrderId(String targetOrderId) {
        this.targetOrderId = targetOrderId;
    }

    public int getRefundAmount() {
        return refundAmount;
    }

    public void setRefundAmount(int refundAmount) {
        this.refundAmount = refundAmount;
    }

    public String getRefundOrderId() {
        return refundOrderId;
    }

    public void setRefundOrderId(String refundOrderId) {
        this.refundOrderId = refundOrderId;
    }

    public int getPlatformAmount() {
        return platformAmount;
    }

    public void setPlatformAmount(int platformAmount) {
        this.platformAmount = platformAmount;
    }

    public List<SubOrder> getSubOrders() {
        return subOrders;
    }

    public void setSubOrders(List<SubOrder> subOrders) {
        this.subOrders = subOrders;
    }

    public String getRefundDesc() {
        return refundDesc;
    }

    public void setRefundDesc(String refundDesc) {
        this.refundDesc = refundDesc;
    }

    public class SubOrder {
        private String mid; // 子商户号
        private String merOrderId; // 商户子订单号
        private String refundOrderId; // 商户退款子订单号
        private int totalAmount; // 子商户分账金额

        public String getMid() {
            return mid;
        }

        public void setMid(String mid) {
            this.mid = mid;
        }

        public String getMerOrderId() {
            return merOrderId;
        }

        public void setMerOrderId(String merOrderId) {
            this.merOrderId = merOrderId;
        }

        public String getRefundOrderId() {
            return refundOrderId;
        }

        public void setRefundOrderId(String refundOrderId) {
            this.refundOrderId = refundOrderId;
        }

        public int getTotalAmount() {
            return totalAmount;
        }

        public void setTotalAmount(int totalAmount) {
            this.totalAmount = totalAmount;
        }
    }

    public static final class Builder {
        private String msgId;
        private String requestTimestamp;
        private String srcReserve;
        private String merOrderId;
        private String instMid;
        private String mid;
        private String tid;
        private String targetOrderId;
        private int refundAmount;
        private String refundOrderId;
        private int platformAmount;
        private List<SubOrder> subOrders;
        private String refundDesc;

        public Builder() {
        }

        public Builder msgId(String val) {
            msgId = val;
            return this;
        }

        public Builder requestTimestamp(String val) {
            requestTimestamp = val;
            return this;
        }

        public Builder srcReserve(String val) {
            srcReserve = val;
            return this;
        }

        public Builder merOrderId(String val) {
            merOrderId = val;
            return this;
        }

        public Builder instMid(String val) {
            instMid = val;
            return this;
        }

        public Builder mid(String val) {
            mid = val;
            return this;
        }

        public Builder tid(String val) {
            tid = val;
            return this;
        }

        public Builder targetOrderId(String val) {
            targetOrderId = val;
            return this;
        }

        public Builder refundAmount(int val) {
            refundAmount = val;
            return this;
        }

        public Builder refundOrderId(String val) {
            refundOrderId = val;
            return this;
        }

        public Builder platformAmount(int val) {
            platformAmount = val;
            return this;
        }

        public Builder subOrders(List<SubOrder> val) {
            subOrders = val;
            return this;
        }

        public Builder refundDesc(String val) {
            refundDesc = val;
            return this;
        }

        public UnionPayUmsRefundBody build() {
            return new UnionPayUmsRefundBody(this);
        }
    }
}
