package cn.com.duiba.paycenter.remoteservice.equity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.paycenter.dto.equity.request.BaseEquityRequest;
import cn.com.duiba.paycenter.dto.equity.request.jigao.EquityJiGaoWetPayMktTransRequest;
import cn.com.duiba.paycenter.dto.equity.response.BaseEquityResultResponse;
import cn.com.duiba.paycenter.dto.equity.response.EquityResponse;
import cn.com.duiba.paycenter.dto.equity.response.jigao.EquityJiGaoWetPayMktTransResponse;

/**
 * 继皋直充-企业付款到零钱
 * @author lizhi
 * @date 2023/6/20 5:44 PM
 */
@AdvancedFeignClient
public interface RemoteEquityJiGaoWetPayMktTransService {

    /**
     * 发放
     * 注意：若结果以mq回调，业务方需要根据业务类型+业务单号幂等<br/>
     * 长时间收不到回调调用查询接口查询<br/>
     *
     * @param request 发放权益请求参数
     * @return 本次请求是否成功
     */
    EquityResponse distribute(BaseEquityRequest<EquityJiGaoWetPayMktTransRequest> request);


    /**
     * 第三方通知结果
     * @param body 通知消息体
     * @return 是否处理成功
     */
    boolean notify(String body);

    /**
     * 查询发放结果
     *
     * @param bizType 业务类型
     *        {@link cn.com.duiba.paycenter.enums.equity.EquityBizTypeEnum}
     * @param bizNo 业务方唯一单号
     * @return 发放权益结果
     */
    BaseEquityResultResponse<EquityJiGaoWetPayMktTransResponse> distributeResult(Integer bizType, String bizNo);
    
}
