package cn.com.duiba.paycenter.dto.payment.charge.cib;


import java.io.Serializable;

/**
 * 汇丰支付通知请求dto
 *
 * @author zouwx
 * @date 2022/10/26
 */
public class CibPayNotifyRequestDTO implements Serializable {

    private static final long serialVersionUID = 6224723179381293419L;

    /**
     * 版本
     */
    private String version;

    /**
     * 字符集
     */
    private String charset;

    /**
     * 签名类型
     */
    private String signType;

    /**
     * 状态
     */
    private String status;

    /**
     * 返回信息，如非空，为错误原因签名失败参数格式校验错误
     */
    private String message;

    /**
     * 网关返回码
     */
    private String code;

    /**
     * 0表示成功，非0表示失败
     */
    private String resultCode;

    /**
     * 商户号，由平台分配
     */
    private String mchId;

    /**
     * 设备信息
     */
    private String deviceInfo;

    /**
     * 随机字符串，不长于 32 位
     */
    private String nonceStr;

    /**
     * 错误代码
     */
    private String errCode;

    /**
     * 错误信息
     */
    private String errMsg;

    /**
     * 签名
     */
    private String sign;

    /**
     * 开放id
     */
    private String openId;

    /**
     * 交易类型
     */
    private String tradeType;

    /**
     * 是否订阅
     */
    private String isSubscribe;

    /**
     * 支付结果
     */
    private Integer payResult;

    /**
     * 支付信息
     */
    private String payInfo;

    /**
     * 平台订单号
     */
    private String transactionId;

    /**
     * 第三方订单号
     */
    private String outTransactionId;

    /**
     * 商户订单号
     */
    private String outTradeNo;

    /**
     * 总费用
     */
    private Integer totalFee;

    /**
     * 交易状态
     */
    private String tradeState;

    private Integer refundFee;

    public Integer getRefundFee() {
        return refundFee;
    }

    public void setRefundFee(Integer refundFee) {
        this.refundFee = refundFee;
    }

    public String getTradeState() {
        return tradeState;
    }

    public void setTradeState(String tradeState) {
        this.tradeState = tradeState;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getCharset() {
        return charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getSignType() {
        return signType;
    }

    public void setSignType(String signType) {
        this.signType = signType;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getResultCode() {
        return resultCode;
    }

    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    public String getMchId() {
        return mchId;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public String getDeviceInfo() {
        return deviceInfo;
    }

    public void setDeviceInfo(String deviceInfo) {
        this.deviceInfo = deviceInfo;
    }

    public String getNonceStr() {
        return nonceStr;
    }

    public void setNonceStr(String nonceStr) {
        this.nonceStr = nonceStr;
    }

    public String getErrCode() {
        return errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getErrMsg() {
        return errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public String getSign() {
        return sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public String getTradeType() {
        return tradeType;
    }

    public void setTradeType(String tradeType) {
        this.tradeType = tradeType;
    }

    public String getIsSubscribe() {
        return isSubscribe;
    }

    public void setIsSubscribe(String isSubscribe) {
        this.isSubscribe = isSubscribe;
    }

    public Integer getPayResult() {
        return payResult;
    }

    public void setPayResult(Integer payResult) {
        this.payResult = payResult;
    }

    public String getPayInfo() {
        return payInfo;
    }

    public void setPayInfo(String payInfo) {
        this.payInfo = payInfo;
    }

    public String getTransactionId() {
        return transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public String getOutTransactionId() {
        return outTransactionId;
    }

    public void setOutTransactionId(String outTransactionId) {
        this.outTransactionId = outTransactionId;
    }

    public String getOutTradeNo() {
        return outTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public Integer getTotalFee() {
        return totalFee;
    }

    public void setTotalFee(Integer totalFee) {
        this.totalFee = totalFee;
    }
}
