package cn.com.duiba.paycenter.dto.payment.charge.cib.refund;

import java.io.Serializable;

/**
 * 兴业银行退款查询返回结果
 *
 * @author zouwx
 * @date 2022/11/29
 */
public class CibRefundQueryRespDTO implements Serializable {

    private static final long serialVersionUID = -6677931763367620359L;

    private Boolean success;

    private String message;

    /**
     * 交易状态
     * SUCCESS—退款成功
     * FAIL—退款失败
     * PROCESSING—退款处理中
     * CHANGE—转入代发，退款到银行发现用户的卡作废或者冻结了，导致原路退款银行卡失败，资金回流到商户的现金帐号，需要商户人工干预，通过线下或者平台转账的方式进行退款。
     *
     */
    private String tradeState;

    /**
     * 兴业订单号
     */
    private String transactionId;

    private Integer refundFee;

    public Integer getRefundFee() {
        return refundFee;
    }

    public void setRefundFee(Integer refundFee) {
        this.refundFee = refundFee;
    }

    public Boolean getSuccess() {
        return success;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getTradeState() {
        return tradeState;
    }

    public void setTradeState(String tradeState) {
        this.tradeState = tradeState;
    }

    public String getTransactionId() {
        return transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }
}
