package cn.com.duiba.paycenter.dto.payment.charge.cib.refund;


import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 兴业银行退款请求
 *
 * @author zouwx
 * @date 2022/11/29
 */
public class CibRefundRequestDTO implements Serializable {

    private static final long serialVersionUID = -219751415064886148L;

    /**
     * 兑吧订单号
     */
    @NotBlank(message = "兑吧订单号不能为空")
    private String outTradeNo;

    /**
     * 退款单号
     */
    private String outRefundNo;

    /**
     * 总费用
     */
    @NotNull(message = "退款总费用不能为空")
    private Integer totalFee;

    /**
     * 退款费用
     */
    @NotNull(message = "退款费用不能为空")
    private Integer refundFee;

    /**
     * 子订单
     */
    private Long ordersItemId;

    public Long getOrdersItemId() {
        return ordersItemId;
    }

    public void setOrdersItemId(Long ordersItemId) {
        this.ordersItemId = ordersItemId;
    }

    public String getOutTradeNo() {
        return outTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public String getOutRefundNo() {
        return outRefundNo;
    }

    public void setOutRefundNo(String outRefundNo) {
        this.outRefundNo = outRefundNo;
    }

    public Integer getTotalFee() {
        return totalFee;
    }

    public void setTotalFee(Integer totalFee) {
        this.totalFee = totalFee;
    }

    public Integer getRefundFee() {
        return refundFee;
    }

    public void setRefundFee(Integer refundFee) {
        this.refundFee = refundFee;
    }
}
