package cn.com.duiba.paycenter.enums;

import org.apache.commons.lang.StringUtils;

import java.util.Objects;

/**
 * @author: pengyi
 * @description:
 * @date: 2022/11/22 下午2:33
 */
public enum WxCouponSubjectEnum {

    FJ_DB_WXLJJ("fjdbwxljj", "福建兑吧微信立减金"),
    DB_FJ_WXLJJ("dbfjwxljj", "兑吧福建微信立减金"),
    DB_FJ_WXLJJ_002("dbfjwxljj002", "兑吧福建微信立减金002"),
    ;

    private String code;

    private String desc;

    public static WxCouponSubjectEnum getByCode(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        WxCouponSubjectEnum[] values = WxCouponSubjectEnum.values();
        for (WxCouponSubjectEnum value : values) {
            if (Objects.equals(value.getCode(), code)) {
                return value;
            }
        }
        return null;
    }

    WxCouponSubjectEnum(String code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
