package cn.com.duiba.paycenter.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author lyj
 * 支付宝数字分行账号接口
 */
@AdvancedFeignClient
public interface RemoteAliAccountService {


    /**
     * 数字分行用户账号查询接口
     * 根据用户logon_Id或者phone_id 查询用户所有可用支付宝账号
     * 文档地址:https://opendocs.alipay.com/pre-apis/09l5u5
     * @param loginId 用户登录账号ID xxx@163.com
     * @return phoneId 用户手机号 139xxxxxxxx
     * @throws BizException bizException
     * @return String 支付宝实名身份ID
     */
    String queryUserAccount(String loginId, String phoneId) throws BizException;

}
