package cn.com.duiba.paycenter.dto.payment.charge.xib.charge;

import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeResponse;

/**
 * xib 支付响应
 *
 * @author zouwx
 * @date 2022/10/24
 */
public class XibChargeResponseDTO extends BaseChargeResponse {

    private static final long serialVersionUID = 2456233002694391265L;
    /**
     * 支付二维码地址
     */
    private String payUrl;

    public static XibChargeResponseDTO fail(String message) {
        XibChargeResponseDTO resp = new XibChargeResponseDTO();
        resp.setSuccess(false);
        resp.setMessage(message);
        return resp;
    }


    public static XibChargeResponseDTO success(String orderNo, String payUrl) {
        XibChargeResponseDTO resp = new XibChargeResponseDTO();
        resp.setSuccess(true);
        resp.setOrderNo(orderNo);
        //收银台地址
        resp.setPayUrl(payUrl);
        return resp;
    }

    @Override
    public String getExtra() {
        return null;
    }

    public String getPayUrl() {
        return payUrl;
    }

    public void setPayUrl(String payUrl) {
        this.payUrl = payUrl;
    }
}
