package cn.com.duiba.paycenter.dto.payment.charge.wxpay.coupon;

import com.alibaba.fastjson.annotation.JSONField;

import java.io.Serializable;

/**
 * 微信立减金批次查询接口
 *
 * @author zouwx
 * @date 2022/12/06
 */
public class WxCouponQueryResp implements Serializable {

    private static final long serialVersionUID = -3494069906214294357L;

    /**
     * 批次id
     */
    @JSONField(name = "stock_id")
    private String stockId;

    /**
     * 创建批次的商户号
     */
    @JSONField(name = "stock_creator_mchid")
    private String stockCreatorMchid;

    /**
     * 批次名称
     */
    @JSONField(name = "stock_name")
    private String stockName;

    /**
     * 批次状态
     */
    @JSONField(name = "status")
    private String status;

    /**
     * 创建时间
     */
    @JSONField(name = "create_time")
    private String createTime;

    /**
     * 描述
     */
    @JSONField(name = "description")
    private String description;

    /**
     * 可用开始时间
     */
    @JSONField(name = "available_begin_time")
    private String availableBeginTime;

    /**
     * 可用结束时间
     */
    @JSONField(name = "available_end_time")
    private String availableEndTime;

    /**
     * 已发券数量
     */
    @JSONField(name = "distributed_coupons")
    private Integer distributedCoupons;

    /**
     * 是否无资金流
     */
    @JSONField(name = "no_cash")
    private Boolean noCash;

    /**
     * 激活批次的时间
     */
    @JSONField(name = "start_time")
    private String startTime;

    /**
     * 终止批次的时间
     */
    @JSONField(name = "stop_time")
    private String stopTime;


    /**
     * 满减券批次使用规则
     */
    @JSONField(name = "stock_use_rule")
    private WxStockUseRuleDTO stockUseRule;

    @JSONField(name = "code")
    private String code;

    @JSONField(name = "message")
    private String message;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getAvailableBeginTime() {
        return availableBeginTime;
    }

    public void setAvailableBeginTime(String availableBeginTime) {
        this.availableBeginTime = availableBeginTime;
    }

    public String getAvailableEndTime() {
        return availableEndTime;
    }

    public void setAvailableEndTime(String availableEndTime) {
        this.availableEndTime = availableEndTime;
    }

    public Integer getDistributedCoupons() {
        return distributedCoupons;
    }

    public void setDistributedCoupons(Integer distributedCoupons) {
        this.distributedCoupons = distributedCoupons;
    }

    public Boolean getNoCash() {
        return noCash;
    }

    public void setNoCash(Boolean noCash) {
        this.noCash = noCash;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getStopTime() {
        return stopTime;
    }

    public void setStopTime(String stopTime) {
        this.stopTime = stopTime;
    }

    public String getStockId() {
        return stockId;
    }

    public void setStockId(String stockId) {
        this.stockId = stockId;
    }

    public String getStockCreatorMchid() {
        return stockCreatorMchid;
    }

    public void setStockCreatorMchid(String stockCreatorMchid) {
        this.stockCreatorMchid = stockCreatorMchid;
    }

    public String getStockName() {
        return stockName;
    }

    public void setStockName(String stockName) {
        this.stockName = stockName;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public WxStockUseRuleDTO getStockUseRule() {
        return stockUseRule;
    }

    public void setStockUseRule(WxStockUseRuleDTO stockUseRule) {
        this.stockUseRule = stockUseRule;
    }


}
