package cn.com.duiba.paycenter.dto.equity.response;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;

/**
 * 权益通用响应
 * @author lizhi
 * @date 2023/4/10 4:03 PM
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class BaseEquityResultResponse<R extends Serializable> extends EquityResponse {

    private static final long serialVersionUID = 2991435633620889367L;

    /**
     * 业务类型
     * {@link cn.com.duiba.paycenter.enums.equity.EquityBizTypeEnum}
     */
    private Integer bizType;

    /**
     * 业务方唯一单号
     */
    private String bizNo;

    /**
     * 状态, 1-初始化，2-处理中，3-内部校验不通过，4-调用第三方发生异常，5-第三方中间状态，6-第三方失败-不能自动重试，7-第三方失败-可自动重试，8-第三方成功，9-内部发生异常
     * 业务方orderStatus处理逻辑：<br/>
     * 8-第三方成功：代表已经成功了，终态，不可再重试<br/>
     * 1-初始化/2-处理中：正在处理中，或者因为极端异常卡在处理中了，需要重试来触发后续流程<br/>
     * 3-内部校验不通过/6-第三方失败-不能自动重试/7-第三方失败-可自动重试：已经明确失败了，若业务需要，可重试来重新发起请求<br/>
     * 4-调用第三方发生异常/5-第三方中间状态/9-内部发生异常：不知道成功还是失败，需要查询第三方来确定最终结果<br/>
     *      a.若渠道有查询接口，可重试触发查询；<br/>
     *      b.若渠道无查询接口，则只能人工判断是否成功，有结果后找开发。注意：开发执行sql需更改tb_equity_order、tb_equity_order_record两张表<br/>
     *          第三方无记录：sql将状态改为3-内部校验不通过，并重试<br/>
     *          第三方失败：sql将状态改为6-第三方失败-不能自动重试/7-第三方失败-可自动重试，并重试<br/>
     *          第三方成功：sql将状态改为8-第三方成功<br/>
     * {@link cn.com.duiba.paycenter.enums.equity.EquityOrderStatusEnum}
     */
    private Integer orderStatus;

    /**
     * 已重试次数
     */
    private Integer retryCount;

    /**
     * 最新的第三方响应的流水号
     */
    private String respSerialNo;

    /**
     * 最新的失败原因
     */
    private String errorMsg;

    /**
     * 权益渠道返回信息
     */
    private R channelResult;
}
