package cn.com.duiba.paycenter.dto.payment.charge.alipay;

import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeNotifyResponse;

/**
 * 支付宝预授权冻结通知响应类
 * 对应支付宝预授权冻结状态通知接口
 * 
 * @author AI Assistant
 * @date 2024/12/19
 */
public class AlipayPreAuthFreezeNotifyResponse extends BaseChargeNotifyResponse {
    private static final long serialVersionUID = 1L;

    /**
     * 支付宝资金授权订单号
     */
    private String authNo;

    /**
     * 商户授权资金订单号
     */
    private String outOrderNo;

    /**
     * 支付宝资金操作流水号
     */
    private String operationId;

    /**
     * 资金操作类型
     * FREEZE：冻结
     * UNFREEZE：解冻
     * PAY：转交易
     */
    private String operationType;

    /**
     * 商户本次资金操作的请求流水号
     */
    private String outRequestNo;

    /**
     * 本次操作金额，单位为：元（人民币），精确到小数点后两位
     */
    private String amount;

    /**
     * 资金操作流水的状态
     * SUCCESS：成功
     * FAIL：失败
     * INIT：处理中
     */
    private String status;

    /**
     * 支付宝资金操作流水创建时间
     * 格式：yyyy-MM-dd HH:mm:ss
     */
    private String gmtCreate;

    /**
     * 支付宝侧资金操作流水的业务时间
     * 格式：yyyy-MM-dd HH:mm:ss
     */
    private String gmtTrans;

    /**
     * 本次操作中信用解冻金额，单位为：元（人民币），精确到小数点后两位
     */
    private String creditAmount;

    /**
     * 本次操作中自有资金解冻金额，单位为：元（人民币），精确到小数点后两位
     */
    private String fundAmount;

    /**
     * 授权资金明细的状态
     * INIT：初始
     * SUCCESS：成功
     * CLOSED：关闭
     */
    private String authStatus;

    /**
     * 预授权订单标题
     */
    private String orderTitle;

    /**
     * 付款方支付宝用户号
     */
    private String payerUserId;

    /**
     * 付款方支付宝登录号
     */
    private String payerLogonId;
    
    /**
     * 应用ID
     */
    private Long appId;

    // Getter and Setter methods
    public String getAuthNo() {
        return authNo;
    }

    public void setAuthNo(String authNo) {
        this.authNo = authNo;
    }

    public String getOutOrderNo() {
        return outOrderNo;
    }

    public void setOutOrderNo(String outOrderNo) {
        this.outOrderNo = outOrderNo;
    }

    public String getOperationId() {
        return operationId;
    }

    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public String getOutRequestNo() {
        return outRequestNo;
    }

    public void setOutRequestNo(String outRequestNo) {
        this.outRequestNo = outRequestNo;
    }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(String gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public String getGmtTrans() {
        return gmtTrans;
    }

    public void setGmtTrans(String gmtTrans) {
        this.gmtTrans = gmtTrans;
    }

    public String getCreditAmount() {
        return creditAmount;
    }

    public void setCreditAmount(String creditAmount) {
        this.creditAmount = creditAmount;
    }

    public String getFundAmount() {
        return fundAmount;
    }

    public void setFundAmount(String fundAmount) {
        this.fundAmount = fundAmount;
    }

    public String getAuthStatus() {
        return authStatus;
    }

    public void setAuthStatus(String authStatus) {
        this.authStatus = authStatus;
    }

    public String getOrderTitle() {
        return orderTitle;
    }

    public void setOrderTitle(String orderTitle) {
        this.orderTitle = orderTitle;
    }

    public String getPayerUserId() {
        return payerUserId;
    }

    public void setPayerUserId(String payerUserId) {
        this.payerUserId = payerUserId;
    }

    public String getPayerLogonId() {
        return payerLogonId;
    }

    public void setPayerLogonId(String payerLogonId) {
        this.payerLogonId = payerLogonId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getOperationType() {
        return operationType;
    }

    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    @Override
    public String toString() {
        return "AlipayPreAuthFreezeNotifyResponse{" +
                "authNo='" + authNo + '\'' +
                ", outOrderNo='" + outOrderNo + '\'' +
                ", operationId='" + operationId + '\'' +
                ", operationType='" + operationType + '\'' +
                ", outRequestNo='" + outRequestNo + '\'' +
                ", amount='" + amount + '\'' +
                ", status='" + status + '\'' +
                ", gmtCreate='" + gmtCreate + '\'' +
                ", gmtTrans='" + gmtTrans + '\'' +
                ", creditAmount='" + creditAmount + '\'' +
                ", fundAmount='" + fundAmount + '\'' +
                ", authStatus='" + authStatus + '\'' +
                ", orderTitle='" + orderTitle + '\'' +
                ", payerUserId='" + payerUserId + '\'' +
                ", payerLogonId='" + payerLogonId + '\'' +
                ", appId=" + appId +
                "} " + super.toString();
    }
} 