package cn.com.duiba.paycenter.dto.payment.charge.alipay;

import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeRequest;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

/**
 * 支付宝预授权支付请求类
 * 对应支付宝 alipay.fund.auth.order.voucher.create 接口
 * 用于在预授权冻结后进行真实支付扣款
 * 
 * @author AI Assistant
 * @date 2024/12/19
 */
public class AlipayPreAuthPayRequest extends BaseChargeRequest {
    private static final long serialVersionUID = -5002740011734334300L;

    /**
     * 支付宝的授权资金订单号
     * 与商户的授权资金订单号不能同时为空，二者都存在时，以支付宝授权资金订单号为准
     */
    @Size(max = 64, message = "支付宝授权资金订单号长度不能超过64")
    private String authNo;

    /**
     * 商户的授权资金订单号
     * 与支付宝的授权资金订单号不能同时为空，二者都存在时，以支付宝授权资金订单号为准
     */
    @Size(max = 64, message = "商户授权资金订单号长度不能超过64")
    private String outOrderNo;

    /**
     * 商户本次资金操作的请求流水号
     * 用于标识一笔业务资金操作请求，需保证在商户端唯一
     */
    @NotBlank(message = "商户请求流水号不能为空")
    @Size(max = 64, message = "商户请求流水号长度不能超过64")
    private String outRequestNo;

    /**
     * 本次操作金额，单位为：元（人民币），精确到小数点后两位
     */
    @NotBlank(message = "操作金额不能为空")
    @Size(max = 16, message = "操作金额长度不能超过16")
    private String payAmount;

    /**
     * 资金操作说明，如果资金操作涉及付款，则该字段必填且长度不能超过100个字符
     */
    @Size(max = 100, message = "操作说明长度不能超过100")
    private String remark;

    /**
     * 业务订单的简单描述，如商品名称等
     */
    @Size(max = 100, message = "订单描述长度不能超过100")
    private String orderTitle;

    /**
     * 扩展参数
     */
    @Size(max = 512, message = "扩展参数长度不能超过512")
    private String extraParam;

    /**
     * 通知地址
     */
    private String notifyUrl;

    // Getter and Setter methods
    public String getAuthNo() {
        return authNo;
    }

    public void setAuthNo(String authNo) {
        this.authNo = authNo;
    }

    public String getOutOrderNo() {
        return outOrderNo;
    }

    public void setOutOrderNo(String outOrderNo) {
        this.outOrderNo = outOrderNo;
    }

    public String getOutRequestNo() {
        return outRequestNo;
    }

    public void setOutRequestNo(String outRequestNo) {
        this.outRequestNo = outRequestNo;
    }

    public String getPayAmount() {
        return payAmount;
    }

    public void setPayAmount(String payAmount) {
        this.payAmount = payAmount;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getOrderTitle() {
        return orderTitle;
    }

    public void setOrderTitle(String orderTitle) {
        this.orderTitle = orderTitle;
    }

    public String getExtraParam() {
        return extraParam;
    }

    public void setExtraParam(String extraParam) {
        this.extraParam = extraParam;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }
}