package cn.com.duiba.paycenter.dto.payment.charge.cib;

import com.alibaba.fastjson.annotation.JSONField;

import java.io.Serializable;

/**
 * cib wx api resp数据
 *
 * @author zouwx
 * @date 2022/10/26
 */
public class CibPayWxApiRespData implements Serializable {

    private static final long serialVersionUID = 7876925091603378142L;

    /**
     * appid
     */
    private String appid;

    /**
     * 版本
     */
    private String version;

    /**
     * 字符集
     */
    private String charset;

    /**
     * 签名类型
     */
    @JSONField(name = "sign_type")
    private String signType;

    /**
     * 状态
     */
    private String status;

    /**
     * 返回信息，如非空，为错误原因签名失败参数格式校验错误
     */
    private String message;

    /**
     * 网关返回码
     */
    private String code;

    /**
     * 0表示成功，非0表示失败
     */
    @JSONField(name = "result_code")
    private String resultCode;

    /**
     * 商户号，由平台分配
     */
    @JSONField(name = "mch_id")
    private String mchId;

    /**
     * 设备信息
     */
    @JSONField(name = "device_info")
    private String deviceInfo;

    /**
     * 随机字符串，不长于 32 位
     */
    @JSONField(name = "nonce_str")
    private String nonceStr;

    /**
     * 错误代码
     */
    @JSONField(name = "err_code")
    private String errCode;

    /**
     * 错误信息
     */
    @JSONField(name = "err_msg")
    private String errMsg;

    /**
     * 签名
     */
    private String sign;

    /**
     * 授权口令
     */
    @JSONField(name = "token_id")
    private String tokenId;

    /**
     * 原生态js支付：is_raw为1时返回，json格式的字符串，作用于原生态js支付时的参数
     * 小程序支付：is_minipg为1时返回，json格式的字符串，作用于小程序支付时的参数
     */
    @JSONField(name = "pay_info")
    private String payInfo;

    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getCharset() {
        return charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getSignType() {
        return signType;
    }

    public void setSignType(String signType) {
        this.signType = signType;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getResultCode() {
        return resultCode;
    }

    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    public String getMchId() {
        return mchId;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public String getDeviceInfo() {
        return deviceInfo;
    }

    public void setDeviceInfo(String deviceInfo) {
        this.deviceInfo = deviceInfo;
    }

    public String getNonceStr() {
        return nonceStr;
    }

    public void setNonceStr(String nonceStr) {
        this.nonceStr = nonceStr;
    }

    public String getErrCode() {
        return errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getErrMsg() {
        return errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public String getSign() {
        return sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String getTokenId() {
        return tokenId;
    }

    public void setTokenId(String tokenId) {
        this.tokenId = tokenId;
    }

    public String getPayInfo() {
        return payInfo;
    }

    public void setPayInfo(String payInfo) {
        this.payInfo = payInfo;
    }
}
