package cn.com.duiba.paycenter.dto.payment.charge.cmb;

import java.io.Serializable;

/**
 * 招商银行-掌上生活-开放平台-H5支付-支付回调-扩展信息
 *
 * @author songp
 * @date 2024/2/20 8:44 下午
 */
public class CmbLifeChargeOrderExtra implements Serializable {
    private static final long serialVersionUID = 8535820434069399309L;

    /**
     * 说明文字/错误信息
     */
    private String message;

    /**
     * 订单金额（单位为分）
     */
    private String amount;

    /**
     * 订单积分
     */
    private String bonus;

    /**
     * 支付方式，从左往右，第一位：招行贷记，第二位：招行借记，第三位：招行外贷记，第四位：招行外借记
     */
    private String payType;

    /**
     * 交易参考号，支付失败时不存在，交易以此对账
     */
    private String refNum;

    /**
     * 屏蔽卡号，积分支付时不存在
     */
    private String shieldCardNo;

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getBonus() {
        return bonus;
    }

    public void setBonus(String bonus) {
        this.bonus = bonus;
    }

    public String getPayType() {
        return payType;
    }

    public void setPayType(String payType) {
        this.payType = payType;
    }

    public String getRefNum() {
        return refNum;
    }

    public void setRefNum(String refNum) {
        this.refNum = refNum;
    }

    public String getShieldCardNo() {
        return shieldCardNo;
    }

    public void setShieldCardNo(String shieldCardNo) {
        this.shieldCardNo = shieldCardNo;
    }
}
