package cn.com.duiba.paycenter.dto.payment.charge.cmb;

import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeRequest;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.Date;

/**
 * @program: pay-center
 * @description: 招商银行一网通支付请求
 * @author: Simba
 * @create: 2019-09-26 14:20
 **/
public class CmbOneNetPayRequest extends BaseChargeRequest {
    private static final long serialVersionUID = -836720030280615504L;
    /**
     * 商品描述
     */
    @Size(max = 255, message = "商品描述超过255")
    @NotNull(message = "商品详情不能为空")
    private String goodsDetail;

    /**
     * 商户用户IP
     * 商户取得的客户IP，如果有多个IP用逗号”,”分隔。
     */
    @Size(max = 64, message = "商户用户IP长度超过64")
    private String clientIP;

    /**
     * 订单日期
     * 格式：yyyyMMdd
     * 含义：订单的日期
     */
    @NotNull(message = "订单日期不能为空")
    private Date orderDate;


    public String getGoodsDetail() {
        return goodsDetail;
    }

    public void setGoodsDetail(String goodsDetail) {
        this.goodsDetail = goodsDetail;
    }

    public String getClientIP() {
        return clientIP;
    }

    public void setClientIP(String clientIP) {
        this.clientIP = clientIP;
    }

    public Date getOrderDate() {
        return orderDate;
    }

    public void setOrderDate(Date orderDate) {
        this.orderDate = orderDate;
    }


}

