package cn.com.duiba.paycenter.dto.payment.charge.wanda;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;

@Data
public class WandaRefundResponse implements Serializable {
    private static final long serialVersionUID = 7748839362635374414L;
    public static String REFUND_STATUS_SUCCESS = "0";
    public static String REFUND_STATUS_FAIL = "1";

    /**
     * 返回码
     * 交易成功返回0，在返回为0时，根据pay_status，判断订单退货状态。其他表示业务报错
     */
    @JSONField(name = "return_code")
    private String returnCode;

    /**
     * 返回码说明
     */
    @JSONField(name = "return_msg")
    private String returnMsg;

    /**
     * 订单状态说明：0-退货成功；1-退货失败；2-退货状态未知
     */
    @JSONField(name = "pay_status")
    private String payStatus;

    /**
     * 实退金额(现金部分)，单位：分
     */
    @JSONField(name = "real_reject_amt")
    private String realRejectAmt;

    /**
     * 工行退货流水号
     */
    @JSONField(name = "intrx_serial_no")
    private String intrxSerialNo;
    /**
     * 退款时间
     */
    @JSONField(name = "refund_time")
    private String refundTime;

}
