package cn.com.duiba.paycenter.enums;

/**
 * 支付宝预授权操作类型枚举
 * 
 * @author AI Assistant
 * @date 2024/12/19
 */
public enum AlipayPreAuthOperationTypeEnum {
    /**
     * 冻结
     */
    FREEZE("FREEZE", "冻结"),
    
    /**
     * 解冻
     */
    UNFREEZE("UNFREEZE", "解冻"),
    
    /**
     * 转支付
     */
    PAY("PAY", "转支付");

    private final String type;
    private final String desc;

    AlipayPreAuthOperationTypeEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 根据类型值获取枚举
     */
    public static AlipayPreAuthOperationTypeEnum getByType(String type) {
        for (AlipayPreAuthOperationTypeEnum typeEnum : values()) {
            if (typeEnum.type.equals(type)) {
                return typeEnum;
            }
        }
        return null;
    }

    /**
     * 判断是否为冻结操作
     */
    public static boolean isFreeze(String type) {
        return FREEZE.type.equals(type);
    }

    /**
     * 判断是否为解冻操作
     */
    public static boolean isUnfreeze(String type) {
        return UNFREEZE.type.equals(type);
    }

    /**
     * 判断是否为转支付操作
     */
    public static boolean isPay(String type) {
        return PAY.type.equals(type);
    }
} 