package cn.com.duiba.paycenter.enums;

/**
 * 支付宝预授权状态枚举
 * 
 * @author AI Assistant
 * @date 2024/12/19
 */
public enum AlipayPreAuthStatusEnum {
    /**
     * 初始状态
     */
    INIT("INIT", "初始"),
    
    /**
     * 成功状态
     */
    SUCCESS("SUCCESS", "成功"),
    
    /**
     * 关闭状态
     */
    CLOSED("CLOSED", "关闭");

    private final String status;
    private final String desc;

    AlipayPreAuthStatusEnum(String status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public String getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 根据状态值获取枚举
     */
    public static AlipayPreAuthStatusEnum getByStatus(String status) {
        for (AlipayPreAuthStatusEnum statusEnum : values()) {
            if (statusEnum.status.equals(status)) {
                return statusEnum;
            }
        }
        return null;
    }

    /**
     * 判断是否为成功状态
     */
    public static boolean isSuccess(String status) {
        return SUCCESS.status.equals(status);
    }

    /**
     * 判断是否为关闭状态
     */
    public static boolean isClosed(String status) {
        return CLOSED.status.equals(status);
    }

    /**
     * 判断是否为最终状态（成功或关闭）
     */
    public static boolean isFinalStatus(String status) {
        return isSuccess(status) || isClosed(status);
    }
} 