/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.pinellie.agent;

import cn.com.duiba.pinellie.agent.PContext;
import cn.com.duiba.pinellie.agent.PEvent;
import cn.com.duiba.pinellie.agent.support.MilliSecondTimer;
import cn.com.duiba.pinellie.agent.support.NetUtils;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PTransactions {
    private static final Logger LOG = LoggerFactory.getLogger(PTransactions.class);
    private AtomicLong atomicLong = new AtomicLong();
    private static final int DEFAULT_STEP = 60;
    private String appName;
    private int step = 60;
    private String metricForCount;
    private String metriForSumKey;
    private double metriForSumValue;
    private boolean isCount = false;
    private long startTime;
    private long endTime;

    public static PTransactions newTransactions() {
        return new PTransactions();
    }

    public PTransactions appName(String appName) {
        this.appName = appName;
        return this;
    }

    public PTransactions step(int step) {
        this.step = step;
        return this;
    }

    public PTransactions build() {
        if (!PContext.getInstance().isInit() || !PContext.getInstance().getpConfig().isOpen()) {
            return this;
        }
        this.startTime = MilliSecondTimer.currentTimeMillis();
        return this;
    }

    public void logMetricForCount(String data) {
        this.metricForCount = data;
        this.isCount = true;
    }

    public void logMetriForSum(String key, double value) {
        this.metriForSumKey = key;
        this.metriForSumValue = value;
    }

    public void complete() {
        block3: {
            try {
                if (!PContext.getInstance().isInit() || !PContext.getInstance().getpConfig().isOpen()) {
                    return;
                }
                this.endTime = MilliSecondTimer.currentTimeMillis();
                this.sendCount();
                this.sendCost();
            }
            catch (Throwable e) {
                long andIncrement = this.atomicLong.getAndIncrement();
                if (andIncrement % 5000L != 0L) break block3;
                this.atomicLong.set(0L);
                LOG.error("send pinellie error ", e);
            }
        }
    }

    private void sendCost() {
        PEvent pEvent = new PEvent();
        pEvent.setEndpoint(NetUtils.getIp());
        String metric = this.isCount ? this.metricForCount : this.metriForSumKey;
        pEvent.setMetric(metric + "-cost");
        pEvent.setValue(this.endTime - this.startTime);
        pEvent.setStep(this.step);
        pEvent.setTags(this.appName);
        pEvent.setTimestamp(MilliSecondTimer.currentTimeMillis());
        pEvent.setType("GAUGE");
        PContext.getInstance().getpHandler().addQueue(pEvent);
    }

    private void sendCount() {
        PEvent pEvent = new PEvent();
        pEvent.setEndpoint(NetUtils.getIp());
        String metric = this.isCount ? this.metricForCount : this.metriForSumKey;
        pEvent.setMetric(metric);
        double value = this.isCount ? 1.0 : this.metriForSumValue;
        pEvent.setValue(value);
        pEvent.setStep(this.step);
        pEvent.setTags(this.appName);
        pEvent.setTimestamp(MilliSecondTimer.currentTimeMillis());
        pEvent.setType(this.isCount ? "COUNTER" : "GAUGE");
        PContext.getInstance().getpHandler().addQueue(pEvent);
    }

    static {
        PContext.getInstance().init();
    }
}

