/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.pinellie.agent;

import cn.com.duiba.pinellie.agent.PContext;
import cn.com.duiba.pinellie.agent.PEvent;
import cn.com.duiba.pinellie.agent.support.PLifeCycle;
import com.alibaba.fastjson.JSON;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PHandler
implements PLifeCycle {
    private static final Logger LOG = LoggerFactory.getLogger(PHandler.class);
    private static final int MAX_TRY_SIZE = 10;
    private volatile boolean isInit;
    private BlockingQueue<PEvent> blockingQueue;
    private ExecutorService executorService;
    private ScheduledExecutorService scheduledExecutorService;
    private CloseableHttpAsyncClient httpclient = HttpAsyncClients.createDefault();
    private AtomicLong successCount = new AtomicLong(0L);
    private AtomicLong failCount = new AtomicLong(0L);
    private AtomicLong cancelCount = new AtomicLong(0L);
    public static final String URL = "http://127.0.0.1:1988/v1/push";

    @Override
    public void init() {
        this.httpclient.start();
        this.blockingQueue = new ArrayBlockingQueue<PEvent>(PContext.getInstance().getpConfig().getQueueSize());
        this.scheduledExecutorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("pinellie data log -" + Thread.currentThread().getId() + "-%d").build());
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                long successCountAndSet = PHandler.this.successCount.getAndSet(0L);
                long failCountAndSet = PHandler.this.failCount.getAndSet(0L);
                long cancelCountAndSet = PHandler.this.cancelCount.getAndSet(0L);
                if (successCountAndSet > 0L || failCountAndSet > 0L || cancelCountAndSet > 0L) {
                    LOG.info("successCount:" + successCountAndSet + " failCount:" + failCountAndSet + " cancelCount:" + cancelCountAndSet);
                }
            }
        }, 5L, 5L, TimeUnit.SECONDS);
        LOG.info("init log scheduledExecutorService success ");
        this.executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), new ThreadFactoryBuilder().setNameFormat("pinellie data send -" + Thread.currentThread().getId() + "-%d").build());
        int i = Runtime.getRuntime().availableProcessors() / 2;
        for (int j = 0; j < 1; ++j) {
            this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    LOG.info("start consumer thread id " + Thread.currentThread().getId());
                    while (true) {
                        PEvent poll;
                        if ((poll = (PEvent)PHandler.this.blockingQueue.poll()) == null) {
                            try {
                                TimeUnit.SECONDS.sleep(1L);
                                continue;
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                        }
                        HttpPost post = new HttpPost(PHandler.URL);
                        post.setHeader("Content-Type", "application/json");
                        post.setHeader("charset", "UTF-8");
                        String jsonString = JSON.toJSONString((Object)poll);
                        StringEntity entity = new StringEntity(jsonString, ContentType.APPLICATION_JSON);
                        post.setEntity((HttpEntity)entity);
                        LOG.info("entity:" + jsonString);
                        PHandler.this.httpclient.execute((HttpUriRequest)post, (FutureCallback)new FutureCallback<HttpResponse>(){

                            public void completed(HttpResponse result) {
                                PHandler.this.successCount.incrementAndGet();
                            }

                            public void failed(Exception ex) {
                                PHandler.this.failCount.incrementAndGet();
                            }

                            public void cancelled() {
                                PHandler.this.cancelCount.incrementAndGet();
                            }
                        });
                    }
                }
            });
        }
        LOG.info("init consumer thread success .  thread size {}", (Object[])new String[]{String.valueOf(i)});
        this.isInit = true;
    }

    @Override
    public void destory() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdownNow();
        }
    }

    @Override
    public boolean isInit() {
        return this.isInit;
    }

    public void addQueue(PEvent pEvent) {
        for (int count = 0; !this.blockingQueue.offer(pEvent) || count > 10; ++count) {
            this.blockingQueue.poll();
        }
    }
}

