/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.pinellie.agent.http;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;

public abstract class AbstractHttpAsyncClientPool {
    private CloseableHttpAsyncClient httpClient;
    private Map<String, AtomicInteger> runningStat = new ConcurrentHashMap<String, AtomicInteger>();

    public abstract CloseableHttpAsyncClient getHttpAsyncClient();

    public abstract int getAppMaxQueue();

    public abstract int getMaxQueue();

    public AbstractHttpAsyncClientPool() {
        this.httpClient = this.getHttpAsyncClient();
        this.httpClient.start();
    }

    public synchronized void submit(String queueKey, HttpUriRequest request, FutureCallback<HttpResponse> callback) {
        AtomicInteger running = this.runningStat.get(queueKey);
        if (running == null) {
            this.runningStat.put(queueKey, new AtomicInteger(1));
        } else {
            running.incrementAndGet();
        }
        this.httpClient.execute(request, (FutureCallback)new CallbackProcesser(queueKey, request, callback));
    }

    public boolean canSubmitToAppPool(String queueKey) {
        int queueCount = 0;
        AtomicInteger running = this.runningStat.get(queueKey);
        if (running != null) {
            queueCount = running.intValue();
        }
        return queueCount < this.getAppMaxQueue();
    }

    public Map<String, Object> dumpDetail() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("runningStat", this.runningStat);
        return map;
    }

    public int dumpSize() {
        int running = 0;
        for (AtomicInteger a : this.runningStat.values()) {
            running += a.get();
        }
        return running;
    }

    private class CallbackProcesser
    implements FutureCallback<HttpResponse> {
        private FutureCallback<HttpResponse> callback;
        private String queueKey;

        public CallbackProcesser(String queueKey, HttpUriRequest request, FutureCallback<HttpResponse> callback) {
            this.callback = callback;
            this.queueKey = queueKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void completed(HttpResponse result) {
            try {
                this.callback.completed((Object)result);
            }
            finally {
                ((AtomicInteger)AbstractHttpAsyncClientPool.this.runningStat.get(this.queueKey)).decrementAndGet();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void failed(Exception ex) {
            try {
                this.callback.failed(ex);
            }
            finally {
                ((AtomicInteger)AbstractHttpAsyncClientPool.this.runningStat.get(this.queueKey)).decrementAndGet();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelled() {
            try {
                this.callback.cancelled();
            }
            finally {
                ((AtomicInteger)AbstractHttpAsyncClientPool.this.runningStat.get(this.queueKey)).decrementAndGet();
            }
        }
    }
}

