/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.pinellie.agent;

import cn.com.duiba.pinellie.agent.PConfig;
import cn.com.duiba.pinellie.agent.PHandler;
import cn.com.duiba.pinellie.agent.support.PLifeCycle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PContext
implements PLifeCycle {
    private static final Logger LOG = LoggerFactory.getLogger(PContext.class);
    private static PContext pContext = new PContext();
    private boolean isInit;
    private boolean isFromLocal;
    private boolean isFromClassPath;
    private PConfig pConfig;
    private PHandler pHandler;

    private PContext() {
    }

    public static PContext getInstance() {
        return pContext;
    }

    @Override
    public void init() {
        this.initConfig();
        this.pHandler = new PHandler();
        this.pHandler.init();
        this.isInit = true;
    }

    private void initConfig() {
        Properties localProperties = new Properties();
        try {
            localProperties.load(new FileInputStream(new File("/home/admin/.pinellie/pinellie.properties")));
            this.isFromLocal = true;
        }
        catch (IOException e) {
            LOG.warn("find properties from /home/admin/.pinellie/pinellie.properties error ", (Throwable)e);
            try {
                localProperties.load(PContext.class.getResourceAsStream("/META-INF/pinellie/pinellie.properties"));
                this.isFromClassPath = true;
            }
            catch (IOException ee) {
                LOG.warn("find properties from /META-INF/pinellie/pinellie.properties error ", (Throwable)e);
            }
        }
        Properties classPathProperties = new Properties();
        if (this.isFromLocal) {
            try {
                classPathProperties.load(PContext.class.getResourceAsStream("/META-INF/pinellie/pinellie.properties"));
                this.isFromClassPath = true;
            }
            catch (IOException ee) {
                LOG.warn("find properties from /META-INF/pinellie/pinellie.properties error ", (Throwable)ee);
            }
        }
        String appName = localProperties.getProperty("pinellie.appName", "pinellia");
        String isOpen = localProperties.getProperty("pinellie.isOpen", "true");
        String queueSize = localProperties.getProperty("pinellie.queueSize", "2000");
        this.pConfig = new PConfig();
        this.pConfig.setAppName(appName);
        this.pConfig.setIsOpen(Boolean.valueOf(isOpen));
        this.pConfig.setQueueSize(Integer.valueOf(queueSize));
        if (this.isFromClassPath && classPathProperties != null) {
            String appNameCP = classPathProperties.getProperty("pinellie.appName", "pinellia");
            this.pConfig.setAppName(appNameCP);
        }
    }

    @Override
    public void destory() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                PContext.this.pHandler.destory();
            }
        });
    }

    @Override
    public boolean isInit() {
        return this.isInit;
    }

    public PHandler getpHandler() {
        return this.pHandler;
    }

    public PConfig getpConfig() {
        return this.pConfig;
    }
}

