package cn.com.duiba.pinellie.agent;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.*;
import java.util.concurrent.atomic.AtomicLong;

import org.apache.http.Consts;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import cn.com.duiba.pinellie.agent.http.HttpClientUtils;
import cn.com.duiba.pinellie.agent.support.PLifeCycle;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;

/**
 * Created by xuezhaoming on 16/6/21.
 */
public final class PHandler implements PLifeCycle {

    private static final Logger      LOG          = LoggerFactory.getLogger(PHandler.class);

    private static final int         MAX_TRY_SIZE = 10;

    private volatile boolean         isInit;

    private BlockingQueue<PEvent>    blockingQueue;

    private ExecutorService          executorService;

    private ScheduledExecutorService scheduledExecutorService;

    private CloseableHttpAsyncClient httpclient   = HttpAsyncClients.createDefault();

    private AtomicLong               successCount = new AtomicLong(0);                      // 成功次数
    private AtomicLong               failCount    = new AtomicLong(0);                      // 失败次数
    private AtomicLong               cancelCount  = new AtomicLong(0);                      // 取消次数

    public static final String       URL          = "http://127.0.0.1:1988/v1/push";

    @Override
    public void init() {

        httpclient.start();

        blockingQueue = new ArrayBlockingQueue(PContext.getInstance().getpConfig().getQueueSize());

        scheduledExecutorService = Executors.newScheduledThreadPool(1,
                                                                    new ThreadFactoryBuilder().setNameFormat("pinellie data log "
                                                                                                                     + "-"
                                                                                                                     + Thread.currentThread().getId()
                                                                                                                     + "-%d").build());

        scheduledExecutorService.scheduleAtFixedRate(new Runnable() {

            @Override
            public void run() {

                long successCountAndSet = successCount.getAndSet(0);
                long failCountAndSet = failCount.getAndSet(0);

                if (successCountAndSet > 0 || failCountAndSet > 0) {
                    LOG.info("successCount:" + successCountAndSet + " failCount:" + failCountAndSet);
                }
            }
        }, 5, 5, TimeUnit.SECONDS);

        LOG.info("init log scheduledExecutorService success ");

        executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(),
                                                       new ThreadFactoryBuilder().setNameFormat("pinellie data send "
                                                                                                        + "-"
                                                                                                        + Thread.currentThread().getId()
                                                                                                        + "-%d").build());

        // int i = Runtime.getRuntime().availableProcessors() / 2;
        // for (int j = 0; j < i; j++) {
        executorService.submit(new Runnable() {

            @Override
            public void run() {

                LOG.info("start consumer thread id " + Thread.currentThread().getId());
                while (true) {
                    PEvent poll = blockingQueue.poll();

                    if (poll == null) {
                        try {
                            TimeUnit.SECONDS.sleep(1);
                            continue;
                        } catch (InterruptedException e) {
                            // ignore
                        }
                    }

                    List<PEvent> pEventList = new ArrayList<PEvent>(1);
                    pEventList.add(poll);
                    Gson gson = new Gson();
                    String jsonString = gson.toJson(pEventList);
                    HttpClientUtils.HttpResult postResult = HttpClientUtils.getInstance().post(URL, jsonString);
                    if (postResult.getStatusCode() == 200) {
                        successCount.getAndIncrement();
                    } else {
                        failCount.getAndIncrement();
                    }

                    LOG.info("data:" + jsonString);
                    // LOG.info("post status=" + postResult.getStatusCode() + " content :" + postResult.getContent());

                    // httpClient(poll);

                    // HttpClientService.get().submit(poll.getTAGS(), post, new FutureCallback<HttpResponse>() {
                    //
                    // @Override
                    // public void completed(HttpResponse result) {
                    //
                    // successCount.incrementAndGet();
                    // }
                    //
                    // @Override
                    // public void failed(Exception ex) {
                    // failCount.incrementAndGet();
                    // }
                    //
                    // @Override
                    // public void cancelled() {
                    // cancelCount.incrementAndGet();
                    //
                    // }
                    // });

                }

            }

            private void httpClient(PEvent poll) {
                HttpPost post = new HttpPost(URL);
                // post.setHeader("Content-Type", "application/json");
                // post.setHeader("charset", "UTF-8");

                List<PEvent> pEventList = new ArrayList<PEvent>(1);
                pEventList.add(poll);
                Gson gson = new Gson();
                String jsonString = gson.toJson(pEventList);

                // 装填参数
                List<NameValuePair> params = new ArrayList<NameValuePair>();
                params.add(new BasicNameValuePair("param", jsonString));
                UrlEncodedFormEntity urlEncodedFormEntity = null;
                try {
                    urlEncodedFormEntity = new UrlEncodedFormEntity(params, Consts.UTF_8.name());
                } catch (UnsupportedEncodingException e) {
                    // irnore
                    return;
                }
                urlEncodedFormEntity.setContentEncoding("UTF-8");
                // urlEncodedFormEntity.setContentType("application/json");
                post.setEntity(urlEncodedFormEntity);

                LOG.info("entity:+++" + jsonString);

                httpclient.execute(post, new FutureCallback<HttpResponse>() {

                    @Override
                    public void completed(HttpResponse result) {
                        StatusLine statusLine = result.getStatusLine();
                        LOG.info("state code" + statusLine.getStatusCode());
                        LOG.info("reason" + statusLine.getReasonPhrase());
                        successCount.incrementAndGet();
                    }

                    @Override
                    public void failed(Exception ex) {
                        failCount.incrementAndGet();
                    }

                    @Override
                    public void cancelled() {
                        cancelCount.incrementAndGet();
                    }
                });
            }
        });
        // }
        LOG.info("init consumer thread success .  ");
        isInit = true;
    }

    @Override
    public void destory() {
        if (executorService != null) {
            executorService.shutdownNow();
        }

        if (scheduledExecutorService != null) {
            scheduledExecutorService.shutdownNow();
        }
    }

    @Override
    public boolean isInit() {
        return isInit;
    }

    public void addQueue(PEvent pEvent) {

        int count = 0;
        while (!blockingQueue.offer(pEvent) || count > MAX_TRY_SIZE) {
            blockingQueue.poll();
            count++;
        }
    }
}
