package cn.com.duiba.pinellie.agent.support;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.common.base.Preconditions;

/**
 */
public class CommandUtil {

    private static final Logger LOGGER = LoggerFactory.getLogger(CommandUtil.class);

    /**
     * 执行linux命令,能处理较长时间的等待
     * 
     * @param cmd
     * @return
     */
    public static String execute(String cmd) {

        Preconditions.checkNotNull(cmd, "cmd is null!");

        LineNumberReader totalInfoReader = null;

        StringBuilder resultString = new StringBuilder();
        try {

            // String[] cmds = { "/bin/sh", "-c", cmd };
            Process process = Runtime.getRuntime().exec(cmd);

            totalInfoReader = new LineNumberReader(new InputStreamReader(process.getInputStream()));

            String line;
            while ((line = totalInfoReader.readLine()) != null) {
                resultString.append(line);
                // LOGGER.info("read info ----- : " + line);
            }

            int resultCode = process.waitFor();
            if (resultCode != 0) {

                BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                StringBuilder errorDesc = new StringBuilder();

                for (String str = errorReader.readLine(); str != null; str = errorReader.readLine()) {
                    errorDesc.append(str);
                }
                throw new RuntimeException("execute shell error. cmd:" + cmd + " . error info : "
                                           + errorDesc.toString());
            }
        } catch (InterruptedException interruptedException) {
            throw new RuntimeException("execute shell error. cmd:" + cmd);
        } catch (IOException e) {
            throw new RuntimeException("execute shell error. cmd:" + cmd);
        } finally {
            if (totalInfoReader != null) {
                try {
                    totalInfoReader.close();
                } catch (IOException e) {
                    LOGGER.warn("close totalInfoReader error ", e);
                }
            }
        }

        return resultString.toString();

    }

    public static void main(String[] args) {
        String execute = CommandUtil.execute("hostname");
        System.out.println(execute);
        // int g = execute.indexOf("G");
        // if (g <= 0) {
        // System.out.println("is small ");
        // }
        // String substring = execute.substring(0, g);
        // Double aDouble = Double.valueOf(substring);
        // System.out.println(g);
        // System.out.println(aDouble);
        // System.out.println(execute);
    }

}
