package cn.com.duiba.pinellie.agent.support;

import java.util.concurrent.locks.LockSupport;

/**
 * This timer provides milli-second precise system time.
 */
public class MilliSecondTimer {

    private static long    mBaseTime;

    private static long    mStartNanoTime;

    private static boolean mIsWindows = false;

    public static long currentTimeMillis() {
        if (mIsWindows) {
            if (mBaseTime == 0) {
                initialize();
            }

            long elapsed = (long) ((System.nanoTime() - mStartNanoTime) / 1e6);

            return mBaseTime + elapsed;
        } else {
            return System.currentTimeMillis();
        }
    }

    public static void initialize() {
        String os = System.getProperty("os.name");

        if (os.startsWith("Windows")) {
            mIsWindows = true;
            mBaseTime = System.currentTimeMillis();

            while (true) {
                LockSupport.parkNanos(100000); // 0.1 ms

                long millis = System.currentTimeMillis();

                if (millis != mBaseTime) {
                    mBaseTime = millis;
                    mStartNanoTime = System.nanoTime();
                    break;
                }
            }
        } else {
            mBaseTime = System.currentTimeMillis();
            mStartNanoTime = System.nanoTime();
        }
    }

    public static void main(String[] args) {
        long l = MilliSecondTimer.currentTimeMillis();
        System.out.println(l);

        long l1 = System.currentTimeMillis();
        System.out.println(l1);
    }
}
