/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.pinellie.agent.http;

import cn.com.duiba.pinellie.agent.http.AbstractHttpAsyncClientPool;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.protocol.HttpContext;

public class HttpClientService
extends AbstractHttpAsyncClientPool {
    public static HttpClientService instance = new HttpClientService();
    public static final int CONNECT_TIMEOUT = 30000;
    public static final int KEEPALIVE_TIMEOUT = 30000;
    public static final int SOCKET_TIMEOUT = 30000;
    public static final int MAX_CONNECT = 4096;
    public static final int MAX_ROUTE_CONNECT = 128;
    public static final int MAX_APP_QUEUE = 100;

    public static HttpClientService get() {
        return instance;
    }

    @Override
    public CloseableHttpAsyncClient getHttpAsyncClient() {
        return HttpAsyncClients.custom().setDefaultRequestConfig(this.getRequestConfig()).setMaxConnTotal(4096).setMaxConnPerRoute(128).setKeepAliveStrategy((ConnectionKeepAliveStrategy)this.getKeepAliveStrategy()).build();
    }

    public DefaultConnectionKeepAliveStrategy getKeepAliveStrategy() {
        return new DefaultConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                long duration = super.getKeepAliveDuration(response, context);
                if (duration == -1L) {
                    return 30000L;
                }
                return duration;
            }
        };
    }

    public RequestConfig getRequestConfig() {
        return RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
    }

    @Override
    public synchronized void submit(String queueKey, HttpUriRequest request, FutureCallback<HttpResponse> callback) {
        super.submit(queueKey, request, callback);
    }

    @Override
    public int getAppMaxQueue() {
        return 100;
    }

    @Override
    public int getMaxQueue() {
        return 4096;
    }
}

