package cn.com.duiba.pinellie.agent;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import cn.com.duiba.pinellie.agent.support.PLifeCycle;

import com.google.common.base.Preconditions;

/**
 * Created by xuezhaoming on 16/6/22.
 */
public class PContext implements PLifeCycle {

    private static final Logger LOG      = LoggerFactory.getLogger(PContext.class);

    private static PContext     pContext = new PContext();

    private volatile boolean    isInit;

    private boolean             isFromLocal;

    private boolean             isFromClassPath;

    // 配置文件
    private PConfig             pConfig;

    // 具体的数据处理
    private PHandler            pHandler;

    private PContext() {

    }

    public static PContext getInstance() {
        return pContext;
    }

    public void init(Properties properties) {

        // 1.加载配置
        Preconditions.checkNotNull(properties, "properties is null");

        String appName = properties.getProperty("pinellie.appName", "pinellia");
        String isOpen = properties.getProperty("pinellie.isOpen", "true");
        String queueSize = properties.getProperty("pinellie.queueSize", "2000");

        pConfig = new PConfig();
        pConfig.setAppName(appName);
        pConfig.setIsOpen(Boolean.valueOf(isOpen));
        pConfig.setQueueSize(Integer.valueOf(queueSize));

        // 2.初始化队列及消费线程
        pHandler = new PHandler();
        pHandler.init();

        isInit = true;

    }

    @Override
    public void init() {

        if (isInit) {
            return;
        }

        // 1.加载配置
        initConfig();

        // 2.初始化队列及消费线程
        pHandler = new PHandler();
        pHandler.init();

        isInit = true;

    }

    private void initConfig() {
        Properties localProperties = new Properties();
        try {
            localProperties.load(new FileInputStream(new File("/home/admin/.pinellie/pinellie.properties")));
            isFromLocal = true;
        } catch (IOException e) {

            LOG.warn("find properties from /home/admin/.pinellie/pinellie.properties error ", e);

            // 1.2 classpath
            try {
                localProperties.load(PContext.class.getResourceAsStream("/META-INF/pinellie/pinellie.properties"));
                isFromClassPath = true;
            } catch (IOException ee) {

                LOG.warn("find properties from /META-INF/pinellie/pinellie.properties error ", e);
            }
        }

        // 若是从本地加载的话，还需要加载classpath路径下的配置
        Properties classPathProperties = new Properties();
        if (isFromLocal) {

            try {
                classPathProperties.load(PContext.class.getResourceAsStream("/META-INF/pinellie/pinellie.properties"));
                isFromClassPath = true;
            } catch (IOException ee) {
                LOG.warn("find properties from /META-INF/pinellie/pinellie.properties error ", ee);
            }

        }

        String appName = localProperties.getProperty("pinellie.appName", "pinellia");
        String isOpen = localProperties.getProperty("pinellie.isOpen", "true");
        String queueSize = localProperties.getProperty("pinellie.queueSize", "2000");

        pConfig = new PConfig();
        pConfig.setAppName(appName);
        pConfig.setIsOpen(Boolean.valueOf(isOpen));
        pConfig.setQueueSize(Integer.valueOf(queueSize));

        // classpath 的appname优先级大于local file
        if (isFromClassPath && classPathProperties != null) {
            String appNameCP = classPathProperties.getProperty("pinellie.appName", "pinellia");
            pConfig.setAppName(appNameCP);
        }
    }

    @Override
    public void destory() {

        Runtime.getRuntime().addShutdownHook(new Thread() {

            @Override
            public void run() {
                pHandler.destory();
            }
        });
    }

    @Override
    public boolean isInit() {
        return isInit;
    }

    public PHandler getpHandler() {
        return pHandler;
    }

    public PConfig getpConfig() {
        return pConfig;
    }

    public static void main(String[] args) {
        Properties properties = new Properties();
        PContext.getInstance().init(properties);
    }
}
