package cn.com.duiba.pinellie.agent.support;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;

/**
 * Created by xuezhaoming on 16/6/22.
 */
public final class NetUtils {

    private static String ip;

    private static String hostName;

    /**
     * 获取本机器IP
     * 
     * @return
     */
    public static String getIp() {

        if (ip != null) {
            return ip;
        }

        synchronized (NetUtils.class) {
            try {

                Enumeration allNetInterfaces = NetworkInterface.getNetworkInterfaces();
                InetAddress inetAddress = null;
                while (allNetInterfaces.hasMoreElements()) {
                    NetworkInterface netInterface = (NetworkInterface) allNetInterfaces.nextElement();
                    System.out.println(netInterface.getName());
                    Enumeration addresses = netInterface.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        inetAddress = (InetAddress) addresses.nextElement();
                        if (inetAddress != null && inetAddress instanceof Inet4Address) {
                            ip = inetAddress.getHostAddress();

                        }
                    }
                }
            } catch (Exception ex) {
                ip = "";
            }
        }

        return ip;
    }

    public static String getHostName() {

        if (hostName != null) {
            return hostName;
        }

        synchronized (NetUtils.class) {
            try {

                Enumeration allNetInterfaces = NetworkInterface.getNetworkInterfaces();
                InetAddress inetAddress = null;
                while (allNetInterfaces.hasMoreElements()) {
                    NetworkInterface netInterface = (NetworkInterface) allNetInterfaces.nextElement();
                    System.out.println(netInterface.getName());
                    Enumeration addresses = netInterface.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        inetAddress = (InetAddress) addresses.nextElement();
                        if (inetAddress != null && inetAddress instanceof Inet4Address) {
                            hostName = inetAddress.getHostAddress();
                            String hostName = inetAddress.getHostName();

                        }
                    }
                }
            } catch (Exception ex) {
                hostName = "";
            }
        }

        return hostName;
    }

    public static String getHostNameLinux() {
        return CommandUtil.execute("hostname");
    }

}
