package cn.com.duiba.plugin.center.api.remoteservice.order;

import cn.com.duiba.biz.tool.duiba.mq.MqDataParam;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.plugin.center.api.dto.ActivityOrderDto;
import cn.com.duiba.plugin.center.api.request.PlaceOrderRequest;
import cn.com.duiba.plugin.center.api.response.PlaceOrderResponse;

import java.util.List;


/**
 * ClassName:RemoteActivityOrderService<br/>
 *
 * @author gey
 * @version 1.0
 * @Description: 插件订单 服务
 * @date 创建时间：2018/5/9  15:28
 * @since JDK 1.8
 **/
@AdvancedFeignClient
public interface RemoteActivityOrderService {
    /**
     * 创建活动订单
     * @param orderDto
     * @return
     */
    String createOrder(ActivityOrderDto orderDto) throws BizException;

    /**
     * 创建活动订单 并且通知奖品中心发放奖品
     * @param mqDataParam
     * @return
     */
    String createOrderAndTakePrize(MqDataParam mqDataParam) throws BizException;

    /**
     * 查询订单信息
     * @param orderNum
     * @return
     */
    ActivityOrderDto findByOrderNum(String orderNum) throws BizException;

    PlaceOrderResponse placeOrder(PlaceOrderRequest request) throws BizException;

//    /**
//     * 订单扣积分成功
//     * @param orderNum
//     * @param activityOptionId
//     * @param activityOptionName
//     * @param activityOptionType
//     * @param activityOptionFacePrice
//     * @param appItemId
//     * @param itemId
//     * @param gid
//     * @param gtype
//     * @param couponId
//     * @return
//     */
//    Boolean consumeCreditsSuccess(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId);
//
//    /**
//     * 订单扣积分成功--降级
//     * @param orderNum
//     * @param activityOptionId
//     * @param activityOptionName
//     * @param activityOptionType
//     * @param activityOptionFacePrice
//     * @param appItemId
//     * @param itemId
//     * @param gid
//     * @param gtype
//     * @param couponId
//     * @return
//     */
//    Boolean consumeCreditsSuccessDowngrade(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId);
//
//
//    /**
//     * 订单扣积分失败
//     * @param orderNum
//     * @param activityOptionId
//     * @param activityOptionName
//     * @param activityOptionType
//     * @param activityOptionFacePrice
//     * @param appItemId
//     * @param itemId
//     * @param gid
//     * @param gtype
//     * @param couponId
//     * @param error4admin
//     * @param error4developer
//     * @param error4consumer
//     * @return
//     */
//    Boolean consumeCreditsFail(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId, String error4admin, String error4developer, String error4consumer);
//
//    /**
//     * 订单加积分成功
//     * @param orderNum
//     * @param activityOptionId
//     * @param activityOptionName
//     * @param activityOptionType
//     * @param activityOptionFacePrice
//     * @param appItemId
//     * @param itemId
//     * @param gid
//     * @param gtype
//     * @param couponId
//     * @return
//     */
//    Boolean addCreditsSuccess(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId);
//
//    /**
//     * 订单加积分失败
//     * @param orderNum
//     * @param activityOptionId
//     * @param activityOptionName
//     * @param activityOptionType
//     * @param activityOptionFacePrice
//     * @param appItemId
//     * @param itemId
//     * @param gid
//     * @param gtype
//     * @param couponId
//     * @param error4admin
//     * @param error4developer
//     * @param error4consumer
//     * @return
//     */
//    Boolean addCreditsFail(String orderNum, Long activityOptionId, String activityOptionName, String activityOptionType, String activityOptionFacePrice, Long appItemId, Long itemId, Long gid, String gtype, Long couponId, String error4admin, String error4developer, String error4consumer);
//
//    /**
//     * 订单加积分处理中状态更新
//     * @param orderNum
//     * @return
//     */
//    Boolean addCreditsStatusToProcessing(String orderNum);
//    /**
//     * 订单置为待领奖状态
//     * @param orderNum
//     * @return
//     */
//    Boolean exchangeStatusToWait(String orderNum);
//
//    /**
//     * 订单置为领奖成功
//     * @param orderNum
//     * @return
//     */
//    Boolean exchangeStatusToSuccess(String orderNum);
//
//    /**
//     * 订单置为领奖失败
//     * @param orderNum
//     * @return
//     */
//    Boolean exchangeStatusToFail(String orderNum);
//
//    /**
//     * 订单置为未领奖过期
//     * @param orderNum
//     * @return
//     */
//    Boolean exchangeStatusToOverdue(String orderNum);
//
    /**
     * 订单批量置为未领奖过期
     * @param orderNums
     * @return
     */
    List<String> exchangeStatusToOverdueBatch(List<String> orderNums);
//
//
//    /**
//     * 根据订单唯一编号修改开发者订单号
//     * @param orderNum
//     * @param developerBizId
//     * @return
//     */
//    Boolean updateDeveloperBizId(String orderNum, String developerBizId);
//
//    /**
//     * 根据订单唯一编号修改加积分开发者订单号
//     * @param orderNum
//     * @param developerBizId
//     * @return
//     */
//    Boolean updateAddDeveloperBizId(String orderNum, String developerBizId);
//
//    /**
//     * 修改主订单号
//     * @param orderNum 订单唯一编号
//     * @param mainOrderNum 主订单唯一编号
//     * @return
//     */
//    Boolean updateMainOrderNum(String orderNum, String mainOrderNum);
//
//    /**
//     * 用户参与兑吧活动次数
//     * @param consumerId
//     * @param duibaActivityId
//     * @param activityType
//     * @return
//     */
//    Integer findConsumerDuibaActivityNum(long consumerId, long duibaActivityId, String activityType);
//
//    /**
//     * 用户参与兑吧活动订单明细
//     * @param consumerId 用户ID
//     * @param duibaActivityIds 兑吧活动id集合
//     * @param activityType 活动类型
//     * @return
//     */
//    List<ActivityOrderDto> findConsumerDuibaActivityNumList(long consumerId, List<Long> duibaActivityIds, String activityType);
//
    /**
     * 用户时间范围参与兑吧活动订单明细
     * @param consumerId
     * @param duibaActivityId
     * @param activityType
     * @param start
     * @param end
     * @return
     */
    ActivityOrderDto findConsumerDuibaActivity4day(long consumerId, Long duibaActivityId, String activityType, String start, String end);
//
//    /**
//     * 根据订单号批量查询订单
//     * @param consumerId
//     * @param orderNums
//     * @return
//     */
//    List<ActivityOrderDto> findByInOrderNums(long consumerId, List<String> orderNums);
//
    /**
     * 根据过期时间查询未领奖的活动订单号集合
     * @param expirationTime 过期时间
     * @param activityType 活动类型
     * @return orderNum队列
     */
    List<String> findByExpirationTime(String expirationTime, String activityType);
//
//    /**
//     * 根据参数获取中奖的奖项id集合
//     * @param consumerId 消费者id
//     * @param appId app的id
//     * @param activityType 活动类型
//     * @return
//     */
//    List<Long> findOptionIds(Long consumerId, Long appId, String activityType);
//
//    /**
//     * 根据appId获取活动订单列表--分页
//     * @param queryMap 条件参数集合
//     * 必传{appId,start,pageSize}
//     * 选传{duibaActivityId,startTime,endTime,activityOptionId,activityOptionType,exchangeStatus,consumerId}
//     * @return
//     */
//    List<ActivityOrderDto> findByAppIdWithPage(Map<String, Object> queryMap);
//
//    /**
//     * 根据appId获取活动订单数
//     * @param queryMap 条件参数集合
//     * 必传{appId}
//     * 选传{duibaActivityId,startTime,endTime,activityOptionId,activityOptionType,exchangeStatus,consumerId}
//     * @return
//     */
//    Integer getCountByAppId(Map<String, Object> queryMap);
//
//    /**
//     * 根据活动ids和appId获取活动失败订单列表
//     * @param activityIds 兑吧活动id集合
//     * @param appId
//     * @return 如[{"failCount":1,"duibaActivityId":105},{"failCount":1,"duibaActivityId":111}]
//     */
//    List<Map<String,Long>> findFailByActivity4App(List<Long> activityIds, Long appId);
//
//    /**
//     * 根据订单号更新添加的积分
//     * @param orderNum 订单号
//     * @param credits 积分
//     * @return
//     */
//    Boolean updateAddCredits(String orderNum, Long credits);
}
