package cn.com.duiba.plugin.center.api.remoteservice.plugin;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.plugin.center.api.dto.ActivityPluginDto;

import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 插件管理端相关接口服务
 * Created by hww on 2018/5/23 下午2:10.
 */
@AdvancedFeignClient
public interface RemoteActivityPluginBackendService {

    /**
     * 创建插件信息
     * @param activityPluginDto
     * @return
     */
    ActivityPluginDto createActivityPluginInfo(ActivityPluginDto activityPluginDto) throws BizException;

    /**
     * 更新插件信息
     * @param activityPluginDto
     * @return
     */
    Integer updateActivityPluginInfo(ActivityPluginDto activityPluginDto) throws BizException;

    /**
     * 更新插件 pluginLimitCount
     * @param id
     * @param pluginLimitCount
     * @return
     * @throws BizException
     */
    Integer updatePluginLimitCountNull(Long id,Integer pluginLimitCount) throws BizException;

    /**
     * 根据id查询插件
     * @param id
     * @return
     */
    ActivityPluginDto findById(Long id) throws BizException;

    /**
     * 更新插件状态
     * @param id
     * @param value
     * @return
     */
    Integer updateStatus(Long id,Integer value) throws BizException;

    /**
     * 删除插件
     * @param id
     * @return
     */
    Integer dellActivityPlugin(Long id) throws BizException;

    /**
     * 分页查询插件信息
     * @param id
     * @param title
     * @param offset
     * @param max
     * @return
     */
    List<ActivityPluginDto> findActivityPluginInfoList(Long id, String title, Integer offset, Integer max) throws BizException;

    /**
     * 查询符合条件的记录总数
     * @param id
     * @param title
     * @param offset
     * @param max
     * @return
     */
    Long findPageCount(Long id,String title,Integer offset, Integer max) throws BizException;

    /**
     * 更新插件自动关闭时间
     * @param autoOffDate
     * @param id
     * @return
     */
    Integer updateAutoOffDateNull(Date autoOffDate, Long id) throws BizException;

    /**
     * 更新插件自动开启时间
     * @param autoOffDate
     * @param id
     * @return
     */
    Integer updateAutoOnDateNull(Date autoOffDate, Long id) throws BizException;

    /**
     * 获取待选的活动库,过滤掉已配置到对应流量规则中的活动,以及定向活动黑名单活动
     * @param appId
     * @param ruleType
     * @param activityType
     * @param developerId
     * @return
     */
    List<ActivityPluginDto> findFilteredPluginsForMng(Long appId, Integer ruleType, Integer activityType,Long developerId) throws BizException;

    /**
     * 根据id批量查询插件信息
     * @param ids
     * @return
     */
    List<ActivityPluginDto> findPluginsByIds(List<Long> ids) throws BizException;

    /**
     * 根据id批量查询插件信息
     * 返回顺序按照传入id序列排列
     * @param ids
     * @param status
     * @return
     */
    List<ActivityPluginDto> findAndSortByIds(List<Long> ids, Integer status) throws BizException;

    /**
     * 查询所有需要自动开启的插件活动id subType = plugin
     * @return
     */
    Set<Long> autoOnPlugin() throws BizException;

    /**
     * 查询所有已开启的插件活动  subType = plugin
     * @return
     */
    List<ActivityPluginDto> findAllOpenPlugin() throws BizException;

    /**
     *  自动下线
     *
     * @return
     */
    Integer autoOffDateScan() throws BizException;

}
