package cn.com.duiba.plugin.center.api.remoteservice.plugin;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.plugin.center.api.dto.ActivityPluginDto;
import cn.com.duiba.plugin.center.api.dto.ActivityPluginVistDto;
import cn.com.duiba.plugin.center.api.enums.PopupTimeAreaEnum;

import java.util.List;
import java.util.Set;

/**
 * Created by hww on 2018/5/24 下午3:33.
 */
@AdvancedFeignClient
public interface RemoteActivityPluginService {

    /**
     * findActivityPluginInfoList:(这里用一句话描述这个方法的作用). <br/>
     * 查询插件活动list
     *
     * @return
     * @since JDK 1.6
     */
    List<ActivityPluginDto> findActivityPluginInfoList();


    // 根据皮肤id查询皮肤
//    PopupActivityBrickDto findBrickById(Long id);

    // 根据id批量查询插件皮肤
//    Map<Long,PopupActivityBrickDto> findBrickByIds(List<Long> ids);

    /**
     * findById:(这里用一句话描述这个方法的作用). <br/>
     * 根据Id查询插件活动
     *
     * @param id
     * @return
     * @since JDK 1.6
     */
    ActivityPluginDto findById(Long id) throws BizException;

    /**
     * updateStatus:(这里用一句话描述这个方法的作用). <br/>
     * 根据Id开启插件活动配置
     *
     * @param id
     * @param value
     * @return
     * @since JDK 1.6
     */
    Integer updateStatus(Long id, Integer value);

    /**
     * 编辑插件活动配置
     */
    Integer updateActivityPluginInfo(Long id, Integer activityType);

    /**
     * 根据Id查询插件活动
     *
     * @return 操作结果
     */
    ActivityPluginVistDto findByActivityIdAndType(Long id, Integer activityType);

    /**
     * 根据流量规则获取插件列表
     * 调用活动中心ActivityFlowRuleService.findListByRule的返回参数进行入参
     * 迁移至comm-center
     * @param ids
     * @return
     */
    List<ActivityPluginDto> findByFlowRule(List<Long> ids);

    //根据id查询插件皮肤
//    PopupActivityBrickDto findBrickByIdNoCache(Long id);

    //根据皮肤id查询皮肤MD5
//    String findMd5ById(Long id);

    /**
     * 首页弹层监控
     * 按照00:30 -- 06:30,06:30 -- 12:30,12:30 -- 18:30,18:30 -- 00:30,四个时间段划分
     * 将appId存入对应集合中，数据只保存12小时
     * 集合数据通过 findAppMarkForPopup 接口获取
     * @see #findAppMarkForPopup(PopupTimeAreaEnum)
     */
    void addAppMarkForPopup(Long appId);

    /**
     * 根据时间段枚举类型获取对应的数据
     * @see PopupTimeAreaEnum
     * @param popupTimeAreaEnum
     * @return
     */
    Set<Long> findAppMarkForPopup(PopupTimeAreaEnum popupTimeAreaEnum);

    /**
     * 根据id list获取插件列表
     *
     * @param ids
     * @return
     */
    List<ActivityPluginDto> findByIds(List<Long> ids);

}
